/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import jsbugs.DateRenderer;
import jsbugs.TableModelSB;
import model2.SBdb;
import model2.SQPick;

public class SQPickTableModel
extends TableModelSB {
    List<SQPick> picks = null;
    char units = (char)77;
    static String[] columnTitles = new String[]{"Sample", "Qualifier", "Surface", "Scheme", "Type", "Boundary", "Mod. By", "Modified"};
    private static final int[] defaultColumnWidths = new int[]{55, 20, 50, 70, 20, 20, 40, 40};
    static final int COL_SAMPLE = 0;
    static final int COL_QUAL = 1;
    static final int COL_SURFACE = 2;
    static final int COL_SCHEME = 3;
    static final int COL_TYPE = 4;
    static final int COL_BND = 5;
    static final int COL_MODIFIER = 6;
    static final int COL_MODIFIED = 7;

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        SQPick pick = this.picks.get(row);
        switch (col) {
            case 0: {
                return pick.getSample().toString(this.units, false, false, true);
            }
            case 2: {
                return pick.getName();
            }
            case 3: {
                try {
                    return pick.getSurface().getScheme().toString();
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            case 4: {
                return pick.getTypeString();
            }
            case 5: {
                return pick.getBnd();
            }
            case 1: {
                return pick.getQualifier();
            }
            case 6: {
                try {
                    return pick.getModifierString();
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 7: {
                return pick.getModified();
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 7: 
        }
        return Date.class;
    }

    @Override
    public int getRowCount() {
        if (this.picks == null) {
            return 0;
        }
        return this.picks.size();
    }

    void setupTable(JTable jTableSQPicks, SBdb sbdb) {
        this.init(jTableSQPicks, sbdb);
        jTableSQPicks.getColumnModel().getColumn(7).setCellRenderer(new DateRenderer());
        jTableSQPicks.setRowHeight(20);
    }

    @Override
    String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    String getPrefString() {
        return "TMSQPICK";
    }

    @Override
    String getPrefOrderString() {
        return "TOSQPICK";
    }

    @Override
    final String getAutoResizeString() {
        return "TARSQPICK";
    }
}

