/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SbugsMLdocument {
    static boolean PARSE_EXECTION_THROWN = false;

    static Document getXmlDocument(File xmlFile) throws JDOMException, IOException, SAXException {
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        Document xmlDocument = null;
        if (!PARSE_EXECTION_THROWN) {
            try {
                xmlDocument = builder.build(xmlFile);
            }
            catch (JDOMParseException pe) {
                System.out.println("JDOM parseException. Using local xsd file because of..." + pe.getMessage());
                PARSE_EXECTION_THROWN = true;
            }
        }
        if (PARSE_EXECTION_THROWN) {
            System.out.println("Attempting validation");
            String schemaLang = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
            String dir = System.getProperty("user.dir");
            File root = new File(dir);
            while (root.getParentFile() != null) {
                root = root.getParentFile();
            }
            System.out.println("Creating validation schema...");
            boolean hasValidator = false;
            try {
                String XSD = "SBugsML2-0.xsd";
                File xsdFile = new File(dir + "\\" + XSD);
                if (!xsdFile.exists()) {
                    xsdFile = new File(root.getAbsoluteFile() + "\\sbugs\\xml\\" + XSD);
                }
                Schema schema = factory.newSchema(new StreamSource(xsdFile));
                System.out.println("Creating validator with " + xsdFile.getPath());
                Validator validator = schema.newValidator();
                hasValidator = true;
                System.out.println("Validating...");
                validator.validate(new StreamSource(xmlFile));
                System.out.println("XML Validation successful");
            }
            catch (SAXParseException pex) {
                System.out.println("Validation error: " + pex.getMessage());
                if (hasValidator) {
                    throw pex;
                }
                System.out.println("Proceeding without validation...");
            }
            builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
            xmlDocument = builder.build(xmlFile);
        }
        return xmlDocument;
    }
}

