/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartProperties;
import jsbugs.PanelAgeCurve;
import jsbugs.PanelAgeScale;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelRange;
import jsbugs.PanelSurfaces;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import model2.AgeCurve;
import model2.CompositeStandard;
import model2.IGDScheme;
import model2.SBdb;
import model2.WellInterp;
import util.SBException;

public class SchemeBlock
extends ChartBlock {
    public static float[] scales = new float[]{0.5f, 1.0f, 5.0f, 20.0f, 50.0f, 100.0f};
    public static final float AGE_SCALE_MIN = 0.1f;
    public static final float AGE_SCALE_MAX = 1000.0f;

    public SchemeBlock() {
        this.prop = new BlockProperties(BlockProperties.ScaleType.AGE);
        this.prop.scale = 5.0f;
    }

    public SchemeBlock(BlockProperties bp) {
        if (bp == null) {
            throw new IllegalArgumentException("Attempt to create scheme block with null properties");
        }
        this.prop = bp;
    }

    float getMinAge() {
        if (this.prop.scaleType != BlockProperties.ScaleType.AGE) {
            if (this.interp != null && this.interp.getLOC() != null) {
                return (float)this.interp.getLOC().getMinAge();
            }
            return 0.0f;
        }
        return this.prop.min;
    }

    float getMaxAge() {
        if (this.prop.scaleType != BlockProperties.ScaleType.AGE) {
            if (this.interp != null && this.interp.getLOC() != null) {
                return (float)this.interp.getLOC().getMaxAge();
            }
            return 0.0f;
        }
        return this.prop.max;
    }

    public float getScale() {
        if (this.prop.scaleType != BlockProperties.ScaleType.AGE) {
            return (this.getMaxAge() - this.getMinAge()) / this.getHeight();
        }
        return this.prop.scale;
    }

    IGDScheme getScheme() {
        for (SBPanel panel : this.panels) {
            if (!panel.getClass().equals(PanelIGDScheme.class)) continue;
            PanelIGDScheme schemePanel = (PanelIGDScheme)panel;
            return schemePanel.getScheme();
        }
        return null;
    }

    CompositeStandard getCompositeStandard() {
        for (SBPanel panel : this.panels) {
            if (!panel.getClass().equals(PanelCompositeStandard.class)) continue;
            PanelCompositeStandard schemePanel = (PanelCompositeStandard)panel;
            return schemePanel.getStd();
        }
        return null;
    }

    SBPanel getPanelHorz(float y) {
        int totalWidth = 0;
        for (SBPanel panel : this.panels) {
            int n;
            if (!(y > (float)totalWidth)) continue;
            totalWidth = (int)((float)totalWidth + panel.getWidth(this.prop));
            if (!(y <= (float)n)) continue;
            return panel;
        }
        return null;
    }

    @Override
    Point2D.Float getPanelOrigin(SBPanel panel, float x, float y, Chart.Mode mode, float xPosInPanel) {
        float xPos = 0.0f;
        for (SBPanel p : this.panels) {
            if (p == panel) {
                return new Point2D.Float(xPos, y);
            }
            xPos += p.getWidth(this.prop);
        }
        return null;
    }

    Point2D.Float getPanelOrigin(SBPanel panel) {
        float xPos = 0.0f;
        float y = 0.0f;
        for (SBPanel p : this.panels) {
            if (p == panel) {
                return new Point2D.Float(xPos, y);
            }
            xPos += p.getWidth(this.prop);
        }
        return null;
    }

    void addScheme(IGDScheme scheme) throws SQLException {
        boolean exists = false;
        if (scheme == null) {
            return;
        }
        for (SBPanel panel : this.panels) {
            PanelIGDScheme schemePanel;
            if (!panel.getClass().equals(PanelIGDScheme.class) || (schemePanel = (PanelIGDScheme)panel).getScheme() != scheme) continue;
            exists = true;
            break;
        }
        if (!exists) {
            if (this.panels.size() == 0 || this.panels.size() == 1 && this.panels.get(0) instanceof PanelAgeScale) {
                this.prop.min = (float)scheme.getMinAge();
                this.prop.max = (float)scheme.getMaxAge();
                this.setIdealScale();
            } else {
                String msg;
                boolean expandMin = false;
                boolean expandMax = false;
                if (scheme.getMinAge() < (double)this.prop.min) {
                    expandMin = true;
                }
                if (scheme.getMaxAge() > (double)this.prop.max) {
                    expandMax = true;
                }
                if ((expandMin || expandMax) && JOptionPane.showConfirmDialog(null, msg = "Expand chart age range to " + (expandMin ? scheme.getMinAge() : (double)this.prop.min) + " - " + (expandMax ? scheme.getMaxAge() : (double)this.prop.max) + " Ma?", "Add Panel", 0) == 0) {
                    if (expandMin) {
                        this.prop.min = (float)scheme.getMinAge();
                    }
                    if (expandMax) {
                        this.prop.max = (float)scheme.getMaxAge();
                    }
                }
            }
            PanelIGDScheme panel = new PanelIGDScheme(scheme, this);
            this.panels.add(panel);
            if (scheme.getIGDType() == 10) {
                PanelSurfaces sPanel = new PanelSurfaces(scheme, this);
                this.panels.add(sPanel);
            }
        }
    }

    void addCompositeStandard(CompositeStandard std, SBdb sbdb) throws SQLException {
        int opt;
        boolean exists = false;
        for (SBPanel panel : this.panels) {
            PanelCompositeStandard cPanel;
            if (!panel.getClass().equals(PanelCompositeStandard.class) || (cPanel = (PanelCompositeStandard)panel).getStd() != std) continue;
            exists = true;
            break;
        }
        if (exists && (opt = JOptionPane.showConfirmDialog(null, "This panel already exists. Add duplicate?", "Add Composite", 0)) != 0) {
            return;
        }
        PanelCompositeStandard panel = new PanelCompositeStandard(std, sbdb, this);
        if (this.panels.isEmpty() || this.panels.size() == 1 && this.panels.get(0) instanceof PanelAgeScale) {
            this.prop.min = (float)std.getMinAge();
            this.prop.max = (float)std.getMaxAge();
            this.setIdealScale();
        }
        this.panels.add(panel);
    }

    void addAgeCurve(AgeCurve curve) throws SQLException {
        boolean exists = false;
        for (SBPanel panel : this.panels) {
            PanelAgeCurve cPanel;
            if (!panel.getClass().equals(PanelAgeCurve.class) || (cPanel = (PanelAgeCurve)panel).getAgeCurveID() != curve.getCurveID()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            PanelAgeCurve panel = new PanelAgeCurve(this, curve);
            if (this.panels.size() == 0) {
                this.prop.min = curve.getYoungest() != null ? curve.getYoungest().floatValue() : 0.0f;
                this.prop.max = curve.getOldest() != null ? curve.getOldest().floatValue() : 0.0f;
                this.setIdealScale();
            }
            this.panels.add(panel);
        }
    }

    boolean addAgeScale() {
        for (SBPanel p : this.panels) {
            if (!(p instanceof PanelAgeScale)) continue;
            return false;
        }
        this.panels.add(0, new PanelAgeScale(this, false));
        return true;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, float zoom) {
        String obj = null;
        float xLeft = 0.0f;
        for (SBPanel panel : this.panels) {
            float xRight = xLeft + panel.getWidth(this.prop);
            if (x < xRight) {
                obj = panel.getTooltip(x - xLeft, y, cp, this.prop, zoom);
                break;
            }
            xLeft = xRight;
        }
        return obj;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, float zoom) {
        Object obj = null;
        float xLeft = 0.0f;
        for (SBPanel panel : this.panels) {
            float xRight = xLeft + panel.getWidth(this.prop);
            if (x < xRight) {
                obj = panel.getObject(x - xLeft, y, cp, this.prop, zoom);
                break;
            }
            xLeft = xRight;
        }
        return obj;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode) {
        return this.drawPanels(g, x, y, p, mode);
    }

    float drawHorz(SBGraphics g, float x, float y, ChartProperties p) {
        Iterator it = this.panels.iterator();
        float yPos = y;
        while (it.hasNext()) {
            SBPanel panel = (SBPanel)it.next();
            yPos += panel.drawHorz(g, x, yPos, p, this.prop);
        }
        return x;
    }

    @Override
    float getHeight() {
        return SchemeBlock.getHeight(this.prop);
    }

    void setWellInterp(WellInterp wellInterp) {
        for (SBPanel panel : this.panels) {
            if (!(panel instanceof PanelIGDScheme)) continue;
            ((PanelIGDScheme)panel).setWellInterp(wellInterp);
        }
    }

    static void fillScaleCombo(DefaultComboBoxModel model) {
        model.removeAllElements();
        for (int i = 0; i < scales.length; ++i) {
            model.addElement(Float.valueOf(scales[i]));
        }
    }

    public static float calcIdealScale(double minAge, double maxAge) {
        double ideal = 500.0 / (maxAge - minAge);
        float closest = scales[scales.length - 1];
        for (int i = scales.length; i > 0 && ideal < (double)scales[i - 1]; --i) {
            closest = scales[i - 1];
        }
        return closest;
    }

    public void setIdealScale() {
        float ideal = 500.0f / (this.prop.max - this.prop.min);
        float closest = scales[scales.length - 1];
        for (int i = scales.length; i > 0 && ideal < scales[i - 1]; --i) {
            closest = scales[i - 1];
        }
        this.prop.scale = closest;
    }

    float scaleAge(float value) {
        if (this.prop.scaleType != BlockProperties.ScaleType.AGE) assert (false);
        try {
            return this.scaleValue(value, BlockProperties.ScaleType.AGE);
        }
        catch (SBException e) {
            throw new IllegalStateException("Inappropriate attempt to scale age: " + e.getMessage());
        }
    }

    String getPanelsString() {
        String string = "";
        for (SBPanel panel : this.panels) {
            if (panel instanceof PanelIGDScheme) {
                PanelIGDScheme panelScheme = (PanelIGDScheme)panel;
                IGDScheme scheme = panelScheme.scheme;
                string = string + scheme.getIGDType() + " " + scheme.getID();
            } else if (panel instanceof PanelCompositeStandard) {
                PanelCompositeStandard pcs = (PanelCompositeStandard)panel;
                string = string + "20 " + pcs.getStd().getStdID();
            } else if (panel instanceof PanelSurfaces) {
                PanelSurfaces panelSurfaces = (PanelSurfaces)panel;
                string = string + "10 " + panelSurfaces.getScheme().getID();
            } else if (panel instanceof PanelAgeCurve) {
                PanelAgeCurve panelAgeCurve = (PanelAgeCurve)panel;
                string = string + "25 " + panelAgeCurve.curve.getCurveID();
            }
            string = string + ",";
        }
        return string;
    }

    void addTokPanel(String panelString, SBdb sbdb) throws SQLException, SBException {
        StringTokenizer tok = new StringTokenizer(panelString);
        int igdType = 0;
        int schID = 0;
        if (tok.hasMoreTokens()) {
            igdType = Integer.parseInt(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            schID = Integer.parseInt(tok.nextToken());
        }
        if (igdType > 0 && schID > 0) {
            switch (igdType) {
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    this.addScheme(sbdb.getIGDScheme(schID, igdType));
                    break;
                }
                case 20: {
                    this.addCompositeStandard(sbdb.getCompositeStandard(schID), sbdb);
                    break;
                }
                case 25: {
                    this.addAgeCurve(sbdb.getAgeCurve(schID));
                }
            }
        }
    }

    void addPanels(SBdb sbdb, LinkedList<Chart.ChartPref> keys) throws SQLException, SBException {
        for (Chart.ChartPref key : keys) {
            switch (key.panelType) {
                case 40: {
                    IGDScheme sch = sbdb.getIGDScheme(key.identifier);
                    sch.loadUnits();
                    if (sch == null) break;
                    this.addPanel(new PanelIGDScheme(sch, this, key.value));
                    break;
                }
                case 42: {
                    CompositeStandard std = sbdb.getCompositeStandard(key.identifier);
                    std.loadEvents();
                    if (std == null) break;
                    this.addPanel(new PanelCompositeStandard(std, sbdb, this, key.value));
                    break;
                }
                case 41: {
                    try {
                        AgeCurve curve = sbdb.getAgeCurve(key.identifier);
                        this.addPanel(new PanelAgeCurve(this, curve, key.value));
                    }
                    catch (SBException sbe) {}
                    break;
                }
                case 43: {
                    this.addPanel(new PanelAgeScale(this, true, key.value));
                    break;
                }
                case 45: {
                    this.addPanel(new PanelRange(sbdb, this, key.value));
                    break;
                }
                case 48: {
                    IGDScheme scheme = sbdb.getIGDScheme(key.identifier);
                    if (scheme == null) break;
                    scheme.loadSurfaces();
                    this.addPanel(new PanelSurfaces(scheme, this, key.value));
                }
            }
        }
    }

    void setData(ChartProperties cp) throws SBException, SQLException, IOException {
        for (SBPanel panel : this.panels) {
            panel.setData(null, null);
        }
    }

    Float[] calcPlotPositions(float age) {
        double[] depths;
        if (this.prop.scaleType != BlockProperties.ScaleType.AGE) {
            depths = this.interp.getLOC().getDepths((double)age);
            if (depths == null) {
                return null;
            }
        } else {
            depths = new double[]{age};
        }
        LinkedList<Float> posList = new LinkedList<Float>();
        for (int i = 0; i < depths.length; ++i) {
            if (this.prop.scaleType != BlockProperties.ScaleType.AGE && (depths[i] < (double)this.prop.min || depths[i] > (double)this.prop.max)) continue;
            try {
                posList.add(Float.valueOf(this.scaleValue((float)depths[i], this.prop.scaleType)));
                continue;
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
        }
        return posList.toArray(new Float[posList.size()]);
    }

    static String getPrefKey(int temp_id) {
        return "C" + temp_id + "0000";
    }
}

