/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbugs.TableModelSurfaces;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.Surface;
import util.ColouredRenderer;
import util.SB;

class SurfaceTableModel
extends AbstractTableModel {
    static String[] colTitles = new String[]{"Surface Name", "Type", "Age", "Occs", "Unit"};
    static int[] colWidths = new int[]{90, 20, 20, 20, 30};
    static final int COL_NAME = 0;
    static final int COL_TYPE = 1;
    static final int COL_AGE = 2;
    static final int COL_OCCS = 3;
    static final int COL_UNIT = 4;
    private final LinkedList<IGDUnit.Builder> units;
    LinkedList<Surface.Builder> scheme = new LinkedList();

    SurfaceTableModel(LinkedList<IGDUnit.Builder> list) {
        this.units = list;
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.scheme == null) {
            return 0;
        }
        return this.scheme.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.scheme.isEmpty()) {
            return "";
        }
        Surface.Builder surface = this.scheme.get(row);
        switch (col) {
            case 0: {
                return surface.getName();
            }
            case 1: {
                return surface.getTypeString();
            }
            case 2: {
                return surface.getAge();
            }
            case 3: {
                return surface.getNOccs();
            }
            case 4: {
                IGDUnit.Builder unit = IGDScheme.findUnit(this.units, (double)surface.getAge(), (boolean)false);
                if (unit == null) {
                    return "";
                }
                return unit.getName();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.scheme.isEmpty()) {
            return;
        }
        Surface.Builder surface = this.scheme.get(row);
        switch (col) {
            case 0: {
                surface.name((String)obj);
                break;
            }
            case 1: {
                surface.type((Surface.SurfaceType)obj);
                break;
            }
            case 2: {
                surface.age(((Double)obj).doubleValue());
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return String.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return IGDUnit.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    void setupTable(JTable table, JComboBox typeCombo) {
        SB.setTableHeaderBold((JTable)table);
        table.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < TableModelSurfaces.colTitles.length; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            table.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
        }
        table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(typeCombo));
        table.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)new ColouredRenderer(false, new Color(220, 220, 220), 4));
        table.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)new ColouredRenderer(false, new Color(220, 220, 220), 4));
    }
}

