/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import model2.TVDList;
import model2.TVDepth;
import util.SB;
import util.SBException;

class TVDTableModel
extends AbstractTableModel {
    Double[] depth;
    Double[] tvd;
    Double[] inclination;
    Double[] azimuth;
    Double[] vs;
    Double[] north;
    Double[] east;
    static final String[] colTitles = new String[]{"Depth", "TVD", "Inclination", "Azimuth", "Horizontal Length", "North", "East"};
    static final int COL_DEPTH = 0;
    static final int COL_TVD = 1;
    static final int COL_INCL = 2;
    static final int COL_AZ = 3;
    static final int COL_VS = 4;
    static final int COL_NORTH = 5;
    static final int COL_EAST = 6;
    char units;
    boolean isDirty = false;
    int rowCount = 0;

    TVDTableModel() {
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public String getColumnName(int col) {
        return colTitles[col];
    }

    public void setSize(int i) {
        this.depth = new Double[i];
        this.tvd = new Double[i];
        this.inclination = new Double[i];
        this.azimuth = new Double[i];
        this.vs = new Double[i];
        this.north = new Double[i];
        this.east = new Double[i];
        this.rowCount = i;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                if (this.depth[row] == null) {
                    return "";
                }
                return SB.floatString((double)this.depth[row], (int)2);
            }
            case 1: {
                if (this.tvd[row] == null) {
                    return "";
                }
                return SB.floatString((double)this.tvd[row], (int)2);
            }
            case 2: {
                if (this.inclination[row] == null) {
                    return "";
                }
                return SB.floatString((double)this.inclination[row], (int)2);
            }
            case 3: {
                if (this.azimuth[row] == null) {
                    return "";
                }
                return SB.floatString((double)this.azimuth[row], (int)2);
            }
            case 4: {
                if (this.vs[row] == null) {
                    return "";
                }
                return SB.floatString((double)this.vs[row], (int)2);
            }
            case 5: {
                if (this.north[row] == null) {
                    return "";
                }
                return SB.floatString((double)this.north[row], (int)2);
            }
            case 6: {
                if (this.east[row] == null) {
                    return "";
                }
                return SB.floatString((double)this.east[row], (int)2);
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            if (obj.getClass().getName().indexOf("String") >= 0) {
                obj = new Double(Double.parseDouble((String)obj));
            }
            switch (col) {
                case 0: {
                    this.depth[row] = (Double)obj;
                    break;
                }
                case 1: {
                    this.tvd[row] = (Double)obj;
                    break;
                }
                case 3: {
                    this.azimuth[row] = (Double)obj;
                    break;
                }
                case 4: {
                    this.vs[row] = (Double)obj;
                    break;
                }
                case 2: {
                    this.inclination[row] = (Double)obj;
                    break;
                }
                case 5: {
                    this.north[row] = (Double)obj;
                    break;
                }
                case 6: {
                    this.east[row] = (Double)obj;
                    break;
                }
            }
            this.isDirty = true;
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void load(TVDList TVDs, char units) {
        this.rowCount = TVDs.getSize();
        this.setSize(this.rowCount);
        this.units = units;
        for (int i = 0; i < this.rowCount; ++i) {
            TVDepth tvdTemp = TVDs.get(i);
            this.setValueAt(new Double(SB.convFromM((double)tvdTemp.getDDepth(), (char)units)), i, 0);
            if (tvdTemp.getTVDepth() != null) {
                this.setValueAt(new Double(SB.convFromM((double)tvdTemp.getTVDepth(), (char)units)), i, 1);
            }
            if (tvdTemp.getInclination() != null) {
                this.setValueAt(new Double(tvdTemp.getInclination().floatValue()), i, 2);
            }
            if (tvdTemp.getAzumith() != null) {
                this.setValueAt(new Double(tvdTemp.getAzumith().floatValue()), i, 3);
            }
            if (tvdTemp.getVS() != null) {
                this.setValueAt(new Double(SB.convFromM((double)tvdTemp.getVS(), (char)units)), i, 4);
            }
            if (tvdTemp.getNorth() != null) {
                this.setValueAt(new Double(SB.convFromM((double)tvdTemp.getNorth(), (char)units)), i, 5);
            }
            if (tvdTemp.getEast() == null) continue;
            this.setValueAt(new Double(SB.convFromM((double)tvdTemp.getEast(), (char)units)), i, 6);
        }
        this.isDirty = false;
    }

    public void save(TVDList TVDs) throws SBException {
        TVDs.clear();
        if (this.rowCount > 0) {
            int i;
            for (i = 0; i < this.rowCount; ++i) {
                if (this.depth[i] == null || !(this.tvd[i] > this.depth[i])) continue;
                throw new SBException("TVD value of: " + SB.floatString((double)this.tvd[i], (int)2) + " cannot be greater than drilled depth: " + SB.floatString((double)this.depth[i], (int)2));
            }
            for (i = 0; i < this.rowCount; ++i) {
                try {
                    if (this.depth[i] == null || !(this.depth[i] >= 0.0) || this.tvd[i] == null) continue;
                    TVDs.add(new TVDepth(SB.convToM((double)this.depth[i], (char)this.units), Double.valueOf(SB.convToM((double)this.tvd[i], (char)this.units)), this.inclination[i] != null ? Float.valueOf(this.inclination[i].floatValue()) : null, this.azimuth[i] != null ? Float.valueOf(this.azimuth[i].floatValue()) : null, this.vs[i] != null ? Double.valueOf(SB.convToM((double)this.vs[i], (char)this.units)) : null, this.north[i] != null ? Double.valueOf(SB.convToM((double)this.north[i], (char)this.units)) : null, this.east[i] != null ? Double.valueOf(SB.convToM((double)this.east[i], (char)this.units)) : null));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void calcTVDVS(String option, JDialog parent, int[] selectedRows) {
        boolean hasIncl = false;
        double lastDepth = this.rowCount > 0 ? this.depth[0] : 0.0;
        for (int row = 0; row < this.rowCount; ++row) {
            if (this.inclination[row] != null) {
                hasIncl = true;
            }
            if (this.depth[row] == null) {
                JOptionPane.showMessageDialog(parent, "There are spaces in the measured depths.", parent.getTitle(), 1);
                return;
            }
            if (this.depth[row] >= lastDepth) continue;
            JOptionPane.showMessageDialog(parent, "The measured depths do not increase at: " + this.depth[row], parent.getTitle(), 1);
            return;
        }
        if (!hasIncl) {
            JOptionPane.showMessageDialog(parent, "There are no inclination data.", parent.getTitle(), 1);
            return;
        }
        if (option.equals("TVD")) {
            this.tvd[0] = this.depth[0];
        } else {
            this.vs[0] = 0.0;
        }
        float incl = this.inclination[0] != null ? this.inclination[0].floatValue() : 0.0f;
        for (int row = 1; row < this.rowCount; ++row) {
            if (this.depth[row] == null) continue;
            float incl1 = incl;
            if (this.inclination[row - 1] != null) {
                incl1 = this.inclination[row - 1].floatValue();
            }
            float incl2 = incl1;
            if (this.inclination[row] != null) {
                incl2 = this.inclination[row].floatValue();
            }
            incl = (incl1 + incl2) / 2.0f;
            double depthincr = this.depth[row] - this.depth[row - 1];
            boolean assignRow = true;
            if (selectedRows != null) {
                assignRow = false;
                for (int i : selectedRows) {
                    if (row != i) continue;
                    assignRow = true;
                    if (this.vs[row - 1] != null) break;
                    JOptionPane.showMessageDialog(parent, "Cannot calculate: the selected rows must not be preceded by missing VS values.", parent.getTitle(), 1);
                    return;
                }
            }
            if (option.equals("TVD")) {
                double tvdincr = depthincr * Math.cos(Math.toRadians(incl));
                if (!assignRow) continue;
                this.tvd[row] = this.tvd[row - 1] + tvdincr;
                continue;
            }
            double vsincr = depthincr * Math.sin(Math.toRadians(incl));
            if (!assignRow) continue;
            this.vs[row] = this.vs[row - 1] + vsincr;
        }
    }

    void calcVS(JDialog parent, int[] selectedRows) {
        int row;
        double lastDepth = this.rowCount > 0 ? this.depth[0] : 0.0;
        for (row = 0; row < this.rowCount; ++row) {
            if (this.depth[row] == null) {
                JOptionPane.showMessageDialog(parent, "Cannot calculate: there are spaces in the measured depths.", parent.getTitle(), 1);
                return;
            }
            if (this.tvd[row] == null) {
                JOptionPane.showMessageDialog(parent, "Cannot calculate: there are spaces in the TV depths.", parent.getTitle(), 1);
                return;
            }
            if (this.depth[row] >= lastDepth) continue;
            JOptionPane.showMessageDialog(parent, "Cannot calculate: the measured depths do not increase at: " + this.depth[row], parent.getTitle(), 1);
            return;
        }
        this.vs[0] = 0.0;
        for (row = 1; row < this.rowCount; ++row) {
            if (this.depth[row] == null) continue;
            double depthincr = this.depth[row] - this.depth[row - 1];
            double tvdincr = this.tvd[row] - this.tvd[row - 1];
            double vsincr = 0.0;
            if (depthincr - tvdincr > 0.0) {
                vsincr = Math.sqrt(depthincr * depthincr - tvdincr * tvdincr);
            }
            boolean assignRow = true;
            if (selectedRows != null) {
                assignRow = false;
                for (int i : selectedRows) {
                    if (row != i) continue;
                    assignRow = true;
                    if (this.vs[row - 1] != null) break;
                    JOptionPane.showMessageDialog(parent, "Cannot calculate: the selected rows must not be preceded by missing VS values.", parent.getTitle(), 1);
                    return;
                }
            }
            if (!assignRow) continue;
            this.vs[row] = this.vs[row - 1] + vsincr;
        }
    }

    void calcNE(JDialog parent, int[] selectedRows) {
        boolean hasAz = false;
        if (this.vs == null || this.vs[0] == null) {
            JOptionPane.showMessageDialog(parent, "No vertical section values. these must be calculated first.", parent.getTitle(), 1);
            return;
        }
        double lastVS = this.rowCount > 0 ? this.vs[0] : 0.0;
        for (int row = 0; row < this.rowCount; ++row) {
            if (this.azimuth[row] != null) {
                hasAz = true;
            }
            if (this.vs[row] == null) {
                JOptionPane.showMessageDialog(parent, "Cannot calculate: there are gaps in the vertical section.", parent.getTitle(), 1);
                return;
            }
            if (this.vs[row] >= lastVS) continue;
            JOptionPane.showMessageDialog(parent, "The vertical section does not increase at: " + this.vs[row], parent.getTitle(), 1);
            return;
        }
        if (!hasAz) {
            JOptionPane.showMessageDialog(parent, "There are no azimuth data.", parent.getTitle(), 1);
            return;
        }
        this.north[0] = 0.0;
        this.east[0] = 0.0;
        float az = this.azimuth[0] != null ? this.azimuth[0].floatValue() : 0.0f;
        for (int row = 1; row < this.rowCount; ++row) {
            if (this.depth[row] == null) continue;
            az = this.azimuth[row].floatValue();
            double vsincr = this.vs[row] - this.vs[row - 1];
            boolean assignRow = true;
            if (selectedRows != null) {
                assignRow = false;
                for (int i : selectedRows) {
                    if (row != i) continue;
                    assignRow = true;
                    break;
                }
            }
            if (!assignRow) continue;
            double nincr = vsincr * Math.cos(Math.toRadians(az));
            this.north[row] = this.north[row - 1] + nincr;
            double eincr = vsincr * Math.sin(Math.toRadians(az));
            this.east[row] = this.east[row - 1] + eincr;
        }
    }
}

