/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.table.AbstractTableModel;
import model2.TWTDepth;
import model2.TWTList;
import util.SB;
import util.SBException;

class TWTTableModel
extends AbstractTableModel {
    Float[] depth;
    Float[] twt;
    char units;
    boolean isDirty = false;
    int rowCount = 0;

    TWTTableModel() {
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public void setSize(int i) {
        this.depth = new Float[i];
        this.twt = new Float[i];
        this.rowCount = i;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                if (this.depth[row] == null) {
                    return "";
                }
                return SB.floatString((float)this.depth[row].floatValue(), (int)2);
            }
            case 1: {
                if (this.twt[row] == null) {
                    return "";
                }
                return SB.floatString((float)this.twt[row].floatValue(), (int)2);
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            if (obj.getClass().getName().indexOf("String") >= 0) {
                obj = new Float(Float.parseFloat((String)obj));
            }
            switch (col) {
                case 0: {
                    this.depth[row] = (Float)obj;
                    break;
                }
                case 1: {
                    this.twt[row] = (Float)obj;
                    break;
                }
            }
            this.isDirty = true;
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void load(TWTList TWTs, char units) {
        this.rowCount = TWTs.getSize();
        this.setSize(this.rowCount);
        this.units = units;
        for (int i = 0; i < this.rowCount; ++i) {
            TWTDepth twtTemp = TWTs.get(i);
            this.setValueAt(new Float(SB.convFromM((double)twtTemp.getDepth(), (char)units)), i, 0);
            this.setValueAt(new Float(SB.convFromM((double)twtTemp.getTWT(), (char)units)), i, 1);
        }
    }

    public void save(TWTList TWTs) throws SBException {
        if (this.rowCount > 0) {
            TWTs.clear();
            for (int i = 0; i < this.rowCount; ++i) {
                try {
                    if (this.depth[i] == null || !(this.depth[i].floatValue() >= 0.0f) || this.twt[i] == null) continue;
                    TWTs.add(new TWTDepth((double)SB.convToM((float)this.depth[i].floatValue(), (char)this.units), (double)SB.convToM((float)this.twt[i].floatValue(), (char)this.units)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

