/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import model2.AgeCurve;
import model2.SBdb;
import util.SB;
import util.SBException;

class TableModelAgeCurves
extends AbstractTableModel {
    List<AgeCurve> ageCurves;
    SBdb db;
    static String[] titles = new String[]{"Title", "Units", "Youngest", "Oldest", "Scheme"};
    static int[] widths = new int[]{60, 20, 20, 20, 60, 60};
    static final int COL_TITLE = 0;
    static final int COL_UNITS = 1;
    static final int COL_YOUNG = 2;
    static final int COL_OLD = 3;
    static final int COL_SCHEME = 4;

    TableModelAgeCurves(SBdb db) {
        this.db = db;
    }

    @Override
    public int getColumnCount() {
        return titles.length;
    }

    @Override
    public int getRowCount() {
        if (this.ageCurves == null) {
            return 0;
        }
        return this.ageCurves.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        AgeCurve ageCurve = this.ageCurves.get(row);
        switch (col) {
            case 0: {
                return ageCurve.getTitle();
            }
            case 1: {
                return ageCurve.getUnits();
            }
            case 2: {
                if (ageCurve.getYoungest() == null) {
                    return "";
                }
                return SB.floatString((double)ageCurve.getYoungest(), (int)3);
            }
            case 3: {
                if (ageCurve.getOldest() == null) {
                    return "";
                }
                return SB.floatString((double)ageCurve.getOldest(), (int)3);
            }
            case 4: {
                try {
                    return this.db.getIGDScheme(ageCurve.getSchID()).toString();
                }
                catch (Exception e) {
                    System.out.println("Error getting IGD scheme: " + e);
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            default: 
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: 
        }
        return String.class;
    }

    void setAgeCurves() throws SQLException, SBException {
        this.ageCurves = this.db.getAgeCurves();
    }

    void setupTable(JTable jTable) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < titles.length; ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(titles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
    }
}

