/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Date;
import java.util.List;
import java.util.Observer;
import javax.swing.JTable;
import jsbugs.DateRenderer;
import jsbugs.DepthRenderer;
import jsbugs.TableModelSB;
import model2.SBdb;
import model2.Smpdtl;
import util.SB;
import util.SBException;

public class TableModelAnalyses
extends TableModelSB {
    char units = (char)77;
    static String[] columnTitles = new String[]{"Top Depth", "Base Depth", "Type", "Label", "Discipline", "Analyst", "Suite", "Split C/M/F", "Weight", "Created", "Modified", "Status"};
    private static final int[] defaultColumnWidths = new int[]{30, 30, 15, 30, 40, 40, 30, 40, 20, 55, 55, 20};
    static final int COL_TOP = 0;
    static final int COL_BASE = 1;
    static final int COL_TYPE = 2;
    static final int COL_LABEL = 3;
    static final int COL_DISC = 4;
    static final int COL_ANALYST = 5;
    static final int COL_ANALYNO = 6;
    static final int COL_SPLITS = 7;
    static final int COL_WEIGHT = 8;
    static final int COL_CREATED = 9;
    static final int COL_MODIFIED = 10;
    static final int COL_STATUS = 11;
    private List<Smpdtl> smpdtls = null;

    void setSmpdtls(List<Smpdtl> smpdtls, Observer obs) {
        this.smpdtls = smpdtls;
        if (obs != null) {
            for (Smpdtl s : smpdtls) {
                s.addObserver(obs);
            }
        }
    }

    List<Smpdtl> getSmpdtls() {
        return this.smpdtls;
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.smpdtls == null) {
            return "";
        }
        Smpdtl smpdtl = this.smpdtls.get(row);
        switch (col) {
            case 4: {
                return SBdb.getDiscAbr((char)smpdtl.getDiscID());
            }
            case 6: {
                return "" + smpdtl.getAnalyNo();
            }
            case 5: {
                try {
                    return smpdtl.getAnalyst();
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 10: {
                Date modified = null;
                if (smpdtl.getModified() != null && !smpdtl.getModified().equals(smpdtl.getCreated())) {
                    modified = smpdtl.getModified();
                    return modified;
                }
                return modified;
            }
            case 9: {
                Date created = smpdtl.getCreated();
                return created;
            }
            case 0: {
                try {
                    if (smpdtl.getSample().getTopDepth() != null) {
                        return SB.floatString((double)smpdtl.getSample().getTopDepth(this.units), (int)2);
                    }
                    return null;
                }
                catch (SBException ex) {
                    ex.printStackTrace();
                    return "Error";
                }
            }
            case 1: {
                try {
                    if (smpdtl.getSample().getBaseDepth() != null) {
                        return SB.floatString((double)smpdtl.getSample().getBaseDepth(this.units), (int)2);
                    }
                    return null;
                }
                catch (SBException ex) {
                    ex.printStackTrace();
                    return "Error";
                }
            }
            case 2: {
                return smpdtl.getSample().getType();
            }
            case 3: {
                return smpdtl.getSample().getLabel();
            }
            case 11: {
                return smpdtl.getAnalysisType().getString();
            }
            case 7: {
                if (smpdtl.getCoarse() > 0.0f || smpdtl.getMedium() > 0.0f || smpdtl.getFine() > 0.0f) {
                    String split = "";
                    split = smpdtl.getCoarse() - (float)((int)smpdtl.getCoarse()) > 0.0f ? split + smpdtl.getCoarse() : split + (int)smpdtl.getCoarse();
                    split = split + "/";
                    split = smpdtl.getMedium() - (float)((int)smpdtl.getMedium()) > 0.0f ? split + smpdtl.getMedium() : split + (int)smpdtl.getMedium();
                    split = split + "/";
                    split = smpdtl.getFine() - (float)((int)smpdtl.getFine()) > 0.0f ? split + smpdtl.getFine() : split + (int)smpdtl.getFine();
                    return split;
                }
                return "";
            }
            case 8: {
                if (smpdtl.getWeight() > 0.0f) {
                    return Float.valueOf(smpdtl.getWeight());
                }
                return null;
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 9: 
            case 10: {
                return Date.class;
            }
            case 8: 
        }
        return Float.class;
    }

    @Override
    public int getRowCount() {
        if (this.smpdtls == null) {
            return 0;
        }
        return this.smpdtls.size();
    }

    void setupTable(JTable jTableAnalyses, SBdb sbdb) {
        this.init(jTableAnalyses, sbdb);
        jTableAnalyses.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
        jTableAnalyses.getColumnModel().getColumn(1).setCellRenderer(new DepthRenderer());
        jTableAnalyses.getColumnModel().getColumn(9).setCellRenderer(new DateRenderer());
        jTableAnalyses.getColumnModel().getColumn(10).setCellRenderer(new DateRenderer());
    }

    @Override
    String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    String getPrefString() {
        return "TMANALYSES";
    }

    @Override
    String getPrefOrderString() {
        return "TOANALYSES";
    }

    @Override
    final String getAutoResizeString() {
        return "TARANALYSE";
    }
}

