/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import model2.Category;
import model2.SBdb;
import util.ColorRenderer;
import util.SB;

class TableModelCategories
extends AbstractTableModel {
    private SBdb db;
    List<Category> catList = null;
    static final int COL_DISC = 0;
    static final int COL_ABR = 1;
    static final int COL_NAME = 2;
    static final int COL_COLOUR = 3;
    static final int COL_OCCS = 4;
    static String[] columnTitles = new String[]{"Disc.", "Abr.", "Name", "Colour", "Genera"};
    static int[] columnWidths = new int[]{30, 20, 100, 5, 5};

    TableModelCategories() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    public void setCats(SBdb db) throws SQLException {
        this.db = db;
        db.loadCatGenOcc();
        this.catList = db.getCategoryList();
    }

    void setupTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.catList == null || this.catList.isEmpty()) {
            return null;
        }
        Category cat = this.catList.get(row);
        if (cat == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return SBdb.getDiscAbr((char)cat.getDiscID());
            }
            case 1: {
                return cat.getMnem();
            }
            case 2: {
                return cat.getName();
            }
            case 3: {
                return cat.getColour();
            }
            case 4: {
                return cat.getNGenera();
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 3: {
                return Color.class;
            }
            case 4: 
        }
        return Integer.class;
    }

    @Override
    public int getRowCount() {
        if (this.catList == null) {
            return 0;
        }
        return this.catList.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.catList == null) {
            return;
        }
        Category cat = this.catList.get(row);
        if (cat == null) {
            return;
        }
        switch (col) {
            case 3: {
                try {
                    this.db.setCatColour(cat.getMnem(), (Color)obj);
                    this.db.commit();
                    break;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error saving colour: " + e.getMessage() + "\n" + SB.sql, "Colour", 0);
                    e.printStackTrace();
                }
            }
        }
    }
}

