/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbugs.FloatRenderer;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.SBEvent;
import model2.SBdb;
import model2.Taxon;
import util.ColouredRenderer;
import util.InvalidFieldException;
import util.SB;

public class TableModelCmpStd
extends AbstractTableModel {
    LinkedList<CompositeStandardEvent.Builder> cmpStd = new LinkedList();
    double minAge;
    double maxAge;
    double topCSU;
    double baseCSU;
    boolean isAgeScale = true;
    String stdName = "";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    static final int COL_EVENT = 0;
    static final int COL_TYPE = 1;
    static final int COL_GEN = 2;
    static final int COL_CSU = 3;
    static final int COL_AGE = 4;
    static final int COL_TAXON = 5;
    private static final String[] columnHeaders = new String[]{"Name", "Type", "Top/Base?", "Age/CSU", "Age", "Taxon"};
    static final String[] tooltips = new String[]{"Event name", "Top (last appearance datum) or Base (first appearance datum)", "Is dictionary event flagged for generating events?", "Age (in Ma or Composite Standard Units)", "Age (Ma)", "Taxon to which dirctionary event is linked (can be null)"};
    private final int[] columnWidths = new int[]{150, 20, 20, 20, 20, 100};

    @Override
    public int getColumnCount() {
        return columnHeaders.length;
    }

    @Override
    public int getRowCount() {
        return this.cmpStd.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            default: {
                return "";
            }
            case 0: {
                return this.cmpStd.get(row).getEvent().getName();
            }
            case 1: {
                return CompositeStandardEvent.getEvTypeString((SBEvent.EventType)this.cmpStd.get(row).getType());
            }
            case 2: {
                return this.cmpStd.get(row).getEvent().isGenerate();
            }
            case 3: {
                return this.cmpStd.get(row).getCSU();
            }
            case 4: {
                double age = this.getAge(this.cmpStd.get(row).getCSU());
                if (age <= 0.0) {
                    return "";
                }
                return age;
            }
            case 5: 
        }
        String string = " ";
        string = string + (this.cmpStd.get(row).getEvent().getTaxon() != null ? this.cmpStd.get(row).getEvent().getTaxon() : "");
        return string;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            default: {
                return;
            }
            case 3: 
        }
        Double csu = Double.parseDouble(obj.toString());
        CompositeStandardEvent.Builder b = this.cmpStd.get(row);
        double initial = b.getCSU();
        b.csu(csu.doubleValue());
        if (Math.abs(initial - csu) > 0.001) {
            this.pcs.firePropertyChange("csu for " + b.getEvent(), initial, csu);
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 5: {
                return Taxon.class;
            }
            case 3: 
            case 4: {
                return Double.class;
            }
            case 2: 
        }
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int r, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 3: 
        }
        return true;
    }

    void setupTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(columnHeaders[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(this.columnWidths[i]);
        }
        Color grey = new Color(240, 240, 240);
        table.setBackground(Color.WHITE);
        table.setDefaultRenderer(Double.class, (TableCellRenderer)new ColouredRenderer(false, grey, 11));
        table.getColumnModel().getColumn(3).setCellRenderer(new FloatRenderer());
        table.setRowHeight(20);
    }

    CompositeStandardEvent.Builder getEvent(int evID, SBEvent.EventType type) {
        for (CompositeStandardEvent.Builder b : this.cmpStd) {
            if (b.getEvent().getEvID() != evID || b.getType() != type) continue;
            return b;
        }
        return null;
    }

    public void updateFields(String name, double minAge, double maxAge, double topCSU, double baseCSU, boolean isAgeScale) {
        this.stdName = name != null ? name : "";
        this.minAge = minAge;
        this.maxAge = maxAge;
        this.topCSU = topCSU;
        this.baseCSU = baseCSU;
        this.isAgeScale = isAgeScale;
        this.pcs.firePropertyChange("All fields", "oldFields", "newFields");
    }

    public void setMinAge(double minAge) {
        double oldMin = this.minAge;
        this.minAge = minAge;
        this.pcs.firePropertyChange("min age", oldMin, minAge);
    }

    public void setMaxAge(double minAge) {
        double old = this.maxAge;
        this.maxAge = minAge;
        this.pcs.firePropertyChange("max age", old, minAge);
    }

    public void setTopCSU(double topCSU) {
        double old = this.topCSU;
        this.topCSU = topCSU;
        this.pcs.firePropertyChange("top CSU", old, topCSU);
    }

    public void setBaseCSU(double baseCSU) {
        double old = this.baseCSU;
        this.baseCSU = baseCSU;
        this.pcs.firePropertyChange("base CSU", old, baseCSU);
    }

    public void setNameField(String name) {
        String old = this.stdName;
        this.stdName = name != null ? name : "";
        this.pcs.firePropertyChange("name", old, this.stdName);
    }

    public void setAgeScale(boolean isAgeScale) {
        boolean old = this.isAgeScale;
        this.isAgeScale = isAgeScale;
        this.pcs.firePropertyChange("scale type", old, isAgeScale);
    }

    private double getAge(double CSU) {
        return CompositeStandard.getAge((double)CSU, (boolean)this.isAgeScale, (double)this.minAge, (double)this.maxAge, (double)this.topCSU, (double)this.baseCSU);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void validateCSU() throws InvalidFieldException {
        double min = this.isAgeScale ? this.minAge : this.topCSU;
        double max = this.isAgeScale ? this.maxAge : this.baseCSU;
        for (CompositeStandardEvent.Builder event : this.cmpStd) {
            if (!(event.getCSU() < Math.min(min, max)) && !(event.getCSU() > Math.max(min, max))) continue;
            throw new InvalidFieldException("'" + CompositeStandardEvent.getEvTypeString((SBEvent.EventType)event.getType()) + " " + event.getEvent() + "' falls outside Age/CSU range of section");
        }
    }

    public int importTaxa(List<Taxon> taxa, SBdb db) throws SQLException {
        int nAdded = 0;
        for (Taxon taxon : taxa) {
            SBEvent event = db.getSBEventGenerate(taxon.getSpecID());
            if (event == null) {
                event = db.addSBEvent(new SBEvent.Builder().name(taxon.toString()).taxon(taxon).isGenerate(true));
                db.commit();
            }
            nAdded += this.importEvent(event);
        }
        return nAdded;
    }

    public int importEvent(SBEvent event) {
        int nAdded = 0;
        if (this.getEvent(event.getEvID(), SBEvent.EventType.TOP) == null) {
            CompositeStandardEvent.Builder csevent = new CompositeStandardEvent.Builder().event(event).type(SBEvent.EventType.TOP);
            this.cmpStd.add(csevent);
            ++nAdded;
        }
        if (this.getEvent(event.getEvID(), SBEvent.EventType.BASE) == null) {
            double csu = 0.0;
            CompositeStandardEvent.Builder fEvent = this.getEvent(event.getEvID(), SBEvent.EventType.TOP);
            if (fEvent != null) {
                csu = fEvent.getCSU();
            }
            CompositeStandardEvent.Builder csevent = new CompositeStandardEvent.Builder().event(event).csu(csu).type(SBEvent.EventType.BASE);
            this.cmpStd.add(csevent);
            ++nAdded;
        }
        return nAdded;
    }
}

