/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import model2.CoredInterval;
import model2.Cores;
import model2.Well;
import util.SB;
import util.SBException;

class TableModelCores
extends AbstractTableModel {
    char units;
    Cores cores;
    Well well;
    static Boolean recovered = true;
    static Boolean notRecovered = false;
    static String[] titles = new String[]{"Top", "Base", "Number", "Recovered?", "+/- top", "+/- base"};
    static int[] widths = new int[]{30, 30, 30, 15, 20, 20};

    TableModelCores() {
    }

    @Override
    public int getColumnCount() {
        return titles.length;
    }

    @Override
    public int getRowCount() {
        if (this.cores == null) {
            return 0;
        }
        return this.cores.getSize();
    }

    void setWell(Well well) throws SQLException, SBException {
        this.well = well;
        this.cores = well.getCores();
        this.units = well.getWellUnits();
    }

    @Override
    public Object getValueAt(int row, int col) {
        CoredInterval core = this.cores.getCore(row);
        switch (col) {
            case 0: {
                return SB.getDepthString((double)core.getTopDepth(), (char)this.units, (int)2);
            }
            case 1: {
                return SB.getDepthString((double)core.getBaseDepth(), (char)this.units, (int)2);
            }
            case 2: {
                return core;
            }
            case 3: {
                return core.getRecovered() ? recovered : notRecovered;
            }
            case 4: {
                try {
                    Float deltaTop = core.getDeltaTop(this.well);
                    if (deltaTop != null) {
                        return SB.getDepthString((double)deltaTop.floatValue(), (char)this.units, (int)2);
                    }
                    return "";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return e.getMessage();
                }
            }
            case 5: {
                try {
                    Float deltaBase = core.getDeltaBase(this.well);
                    if (deltaBase != null) {
                        return SB.getDepthString((double)deltaBase.floatValue(), (char)this.units, (int)2);
                    }
                    return "";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return e.getMessage();
                }
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            default: 
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                return String.class;
            }
            case 2: {
                return CoredInterval.class;
            }
            case 3: 
            case 6: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public void load(Cores cores, char units) {
        this.cores = cores;
    }
}

