/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import model2.Curve;
import model2.Curves;
import model2.LogDef;
import model2.Well;
import util.SB;

class TableModelCurves
extends AbstractTableModel {
    char units;
    Curves curves;
    Well well;
    static String[] titles = new String[]{"Abr.", "Type", "Mnemonic", "Top", "Base", "Source"};
    static int[] widths = new int[]{30, 60, 30, 20, 20, 80};
    static final int COL_ABR = 0;
    static final int COL_TYPE = 1;
    static final int COL_MNEM = 2;
    static final int COL_TOP = 3;
    static final int COL_BASE = 4;
    static final int COL_SOURCE = 5;

    TableModelCurves() {
    }

    @Override
    public int getColumnCount() {
        return titles.length;
    }

    @Override
    public int getRowCount() {
        if (this.curves == null) {
            return 0;
        }
        return this.curves.getSize();
    }

    void setWell(Well well) throws SQLException {
        this.well = well;
        this.curves = well.getCurves();
        this.units = well.getWellUnits();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Curve curve = (Curve)this.curves.getCurves().get(row);
        switch (col) {
            case 3: {
                if (curve.getTopDepth() != null) {
                    return SB.getDepthString((double)curve.getTopDepth(), (char)this.units, (int)2, (char)this.well.getType());
                }
                return "";
            }
            case 4: {
                if (curve.getBaseDepth() != null) {
                    return SB.getDepthString((double)curve.getBaseDepth(), (char)this.units, (int)2, (char)this.well.getType());
                }
                return "";
            }
            case 0: {
                return curve.getAbr();
            }
            case 1: {
                try {
                    return ((LogDef)this.well.getDataModel().getLogDef().get(curve.getAbr())).getTitle();
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            case 2: {
                return curve.getMnem();
            }
            case 5: {
                return curve.getFilename();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            default: 
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: 
        }
        return String.class;
    }

    void setupTable(JTable jTable) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < titles.length; ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(titles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
    }
}

