/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.ComboCellRenderer;
import jsbugs.IGDColmapJPanel;
import model2.IGDColMap;
import model2.IGDIntervalZone;
import util.SB;

class TableModelIGDColmap
extends AbstractTableModel {
    static final int COL_COL = 0;
    static final int COL_MINHIER = 1;
    static final int COL_MAXHIER = 2;
    static final String[] colTitles = new String[]{"Column", "Level: From", "Level: To"};
    static final int[] colWidths = new int[]{60, 40, 40};
    IGDColMap colmap;
    int igdType;
    IGDColmapJPanel panel;

    TableModelIGDColmap() {
    }

    @Override
    public int getRowCount() {
        if (this.colmap == null) {
            return 0;
        }
        try {
            return this.colmap.getSize();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.colmap == null) {
            return "";
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return this.colmap.getColTitle(rowIndex + 1);
                }
                case 1: {
                    return IGDIntervalZone.getHierName((int)this.igdType, (int)this.colmap.getMinhier(rowIndex + 1), (boolean)true);
                }
                case 2: {
                    return IGDIntervalZone.getHierName((int)this.igdType, (int)this.colmap.getMaxhier(rowIndex + 1), (boolean)true);
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.colmap == null) {
            return;
        }
        try {
            String level = obj.toString();
            int hier = IGDIntervalZone.getHierNumber((int)this.igdType, (String)level, (boolean)true);
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    this.colmap.setHier(row + 1, hier, Math.max(hier, this.colmap.getMaxhier(row + 1)));
                    this.fireTableDataChanged();
                    if (this.panel == null) break;
                    this.panel.repaint();
                    this.panel.getParent().repaint();
                    break;
                }
                case 2: {
                    this.colmap.setHier(row + 1, Math.min(hier, this.colmap.getMaxhier(row + 1)), hier);
                    this.fireTableDataChanged();
                    if (this.panel == null) break;
                    this.panel.repaint();
                    this.panel.getParent().repaint();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: 
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    void setupTable(JTable jTable) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        jTable.getColumnModel().getColumn(2).setCellRenderer(new ComboCellRenderer());
        jTable.getColumnModel().getColumn(1).setCellRenderer(new ComboCellRenderer());
    }
}

