/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.DateRenderer;
import model2.IGDHdr;
import model2.SBdb;
import model2.Userdef;
import util.SB;

class TableModelIGDHdrs
extends AbstractTableModel {
    static final int COL_SCHEME = 0;
    static final int COL_COMMENTS = 1;
    static final int COL_SOURCE = 2;
    static final int COL_AUTHOR = 3;
    static final int COL_CREATED = 4;
    static final int COL_CREATOR = 5;
    static final int COL_MODIFIED = 6;
    static final int COL_MODIFIER = 7;
    static final String[] colTitles = new String[]{"Scheme", "Comments", "Source", "Authorised", "Created", "Creator", "Modified", "Modifier"};
    static final int[] colWidths = new int[]{50, 80, 40, 40, 30, 30, 30, 30};
    List<IGDHdr> hdrs;
    SBdb db;

    TableModelIGDHdrs() {
    }

    @Override
    public int getRowCount() {
        if (this.hdrs == null) {
            return 0;
        }
        return this.hdrs.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.hdrs == null) {
            return "";
        }
        try {
            IGDHdr hdr = this.hdrs.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return this.db.getIGDScheme(hdr.getSchID());
                }
                case 1: {
                    return hdr.getComments();
                }
                case 2: {
                    return hdr.getSource();
                }
                case 3: {
                    return hdr.getAuthorised();
                }
                case 4: {
                    Date created = hdr.getCreated();
                    return created;
                }
                case 6: {
                    Date modified = hdr.getModified();
                    return modified;
                }
                case 5: {
                    Userdef user;
                    if (hdr.getCreator() > 0 && (user = this.db.getUser(hdr.getCreator())) != null) {
                        return user.getAbr();
                    }
                    return "";
                }
                case 7: {
                    Userdef user;
                    if (hdr.getModifier() > 0 && (user = this.db.getUser(hdr.getModifier())) != null) {
                        return user.getAbr();
                    }
                    return "";
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: {
                return String.class;
            }
            case 4: 
            case 6: 
        }
        return Date.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    void setupTable(JTable jTable) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        jTable.getColumnModel().getColumn(4).setCellRenderer(new DateRenderer());
        jTable.getColumnModel().getColumn(6).setCellRenderer(new DateRenderer());
    }
}

