/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import model2.IGDScheme;
import util.SB;

class TableModelIGDSuggest
extends AbstractTableModel {
    static final int COL_SCHEME = 0;
    static final int COL_UNIT_MATCHES = 1;
    static final int COL_INFORMAL_MATCHES = 2;
    static final String[] colTitles = new String[]{"Scheme", "Number of unit matches", "Number of matching informal terms"};
    static final int[] colWidths = new int[]{100, 40, 40};
    int nInformal = 0;
    int nUnits = 0;
    List<IGDScheme.MatchSchemes> list;

    TableModelIGDSuggest() {
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IGDScheme.MatchSchemes match = this.list.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    return match.getScheme().toString();
                }
                case 1: {
                    return "" + match.getNMatches() + "/" + match.getScheme().getUnits().size();
                }
                case 2: {
                    return "" + match.getNInformal() + "/" + match.getnUniqiueInformal() + "(" + this.nInformal + " zones)";
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: 
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        table.getTableHeader().setReorderingAllowed(false);
    }
}

