/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import model2.ImageSet;
import model2.SBdb;
import util.SB;
import util.TextAreaRenderer;

public class TableModelImageSet
extends AbstractTableModel {
    static final int IMAGE_SIZE = 175;
    ImageSet set = null;
    SBdb db;
    static String[] colTitles = new String[]{"Number", "Image", "Caption"};
    static int[] colWidth = new int[]{20, 100, 175};
    static final int COL_NO = 0;
    static final int COL_IMAGE = 1;
    static final int COL_CAPTION = 2;

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.set == null) {
            return null;
        }
        try {
            switch (col) {
                case 0: {
                    return row + 1;
                }
                case 2: {
                    return this.set.getImage(row).getCaption();
                }
                case 1: {
                    return this.set.getImage(row).getImage(175, 175, true);
                }
            }
            return "";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 0: {
                return Integer.class;
            }
            case 1: 
        }
        return ImageIcon.class;
    }

    @Override
    public int getRowCount() {
        if (this.set == null) {
            return 0;
        }
        try {
            return this.set.getSize();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean isCellEditable(int r, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 2: 
        }
        return true;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            switch (col) {
                default: {
                    return;
                }
                case 2: 
            }
            String caption = obj.toString();
            if (caption.length() > 255) {
                caption = caption.substring(0, 255);
            }
            this.set.getImage(row).setCaption(caption);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setupTable(JTable jTableImageSet) {
        SB.setTableHeaderBold((JTable)jTableImageSet);
        for (int i = 0; i < colTitles.length; ++i) {
            jTableImageSet.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
            jTableImageSet.getColumnModel().getColumn(i).setPreferredWidth(colWidth[i]);
        }
        jTableImageSet.setRowHeight(175);
        jTableImageSet.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new TextAreaRenderer(false, jTableImageSet.getFont()));
        jTableImageSet.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new TextAreaRenderer(false, jTableImageSet.getFont()));
        jTableImageSet.getTableHeader().setReorderingAllowed(false);
    }
}

