/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import jsbugs.DepthRenderer;
import jsbugs.LithologyCellRenderer;
import model2.LithBase;
import model2.LithInterval;
import model2.LithQualifier;
import model2.Lithdesc;
import model2.Lithology;
import util.SB;

class TableModelIntLith
extends AbstractTableModel {
    static final int COL_TOP = 0;
    static final int COL_BASE = 1;
    static final int COL_LITH = 2;
    static final int COL_PATTERN = 3;
    static final int COL_ALIGNMENT = 4;
    static final int COL_POSITION = 5;
    final String[] colTitles = new String[]{"Top", "Base", "Lithology", "Pattern", "Alignment", "Position/Size"};
    final int[] colWidths = new int[]{30, 30, 120, 40, 40, 40};
    char units = (char)77;
    char type = (char)87;
    List<LithBase> list = null;
    Lithdesc lithdesc;
    JComboBox intervalComboBox = null;
    JComboBox alignmentComboBox = null;

    TableModelIntLith() {
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LithBase lith = this.list.get(rowIndex);
        if (lith == null) {
            return "";
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return SB.floatString((double)SB.convFromM((double)lith.getTopDepth(), (char)this.units, (char)this.type), (int)2);
                }
                case 1: {
                    if (lith instanceof LithQualifier) {
                        return "";
                    }
                    return SB.floatString((double)SB.convFromM((double)((LithInterval)lith).getBaseDepth(), (char)this.units, (char)this.type), (int)2);
                }
                case 2: {
                    if (lith.getLithology() == null) {
                        return "";
                    }
                    return this.lithdesc.getQualifiedLithdesc(lith.getLithology());
                }
                case 3: {
                    return lith.getLithology();
                }
                case 4: {
                    if (lith instanceof LithInterval) {
                        return "";
                    }
                    LithQualifier lithQualifier = (LithQualifier)lith;
                    if (lithQualifier.getType() == 'S') {
                        return lithQualifier.getAlignmentString();
                    }
                    return "";
                }
                case 5: {
                    if (lith instanceof LithInterval) {
                        return null;
                    }
                    LithQualifier lithQualifier = (LithQualifier)lith;
                    return new Float(lithQualifier.getXpos());
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            LithBase lith = this.list.get(row);
            if (lith == null) {
                return;
            }
            switch (col) {
                case 0: {
                    lith.setTopDepth(SB.convToM((double)Double.parseDouble(obj.toString()), (char)this.units, (char)this.type));
                    return;
                }
                case 1: {
                    LithBase nextLith;
                    if (!(lith instanceof LithInterval)) return;
                    double depth = SB.convToM((double)Double.parseDouble(obj.toString()), (char)this.units, (char)this.type);
                    ((LithInterval)lith).setBaseDepth(depth);
                    if (this.list.size() <= row + 1 || !((nextLith = this.list.get(row + 1)) instanceof LithInterval) || !(nextLith.getTopDepth() < (double)0.0029f)) return;
                    nextLith.setTopDepth(depth);
                    return;
                }
                case 2: {
                    System.out.println("Looking up: " + obj.toString());
                    Lithology descr = this.lithdesc.getLithologyFromDescription(obj.toString());
                    System.out.println("Lithdesc is: " + descr);
                    if (descr != null) {
                        if (lith instanceof LithQualifier && descr.isQual()) {
                            lith.setLithology(descr);
                            return;
                        }
                        if (lith instanceof LithInterval && !descr.isQual()) {
                            lith.setLithology(descr);
                            return;
                        }
                        lith.setLithology(null);
                        return;
                    }
                    lith.setLithology(null);
                    return;
                }
                default: {
                    return;
                }
                case 4: {
                    if (!(lith instanceof LithQualifier) || obj.toString().length() <= 0) return;
                    String strg = obj.toString();
                    ((LithQualifier)lith).setAlignment(strg.charAt(0));
                    return;
                }
                case 5: {
                    if (!(lith instanceof LithQualifier) || obj.toString().length() <= 0) return;
                    String strg = obj.toString();
                    if (Float.parseFloat(strg) > 100.0f) {
                        strg = "100.0";
                    }
                    ((LithQualifier)lith).setXpos(Float.parseFloat(strg));
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return Lithology.class;
            }
            default: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: 
        }
        return Float.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        LithBase lith = this.list.get(row);
        switch (col) {
            case 0: 
            case 2: {
                return true;
            }
            case 1: {
                return !(lith instanceof LithQualifier);
            }
            case 4: 
            case 5: {
                return lith instanceof LithQualifier;
            }
        }
        return false;
    }

    void setupTable(JTable jTable) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(this.colTitles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
        }
        TableColumnModel model = jTable.getColumnModel();
        model.getColumn(0).setCellRenderer(new DepthRenderer());
        model.getColumn(1).setCellRenderer(new DepthRenderer());
        model.getColumn(3).setCellRenderer(new LithologyCellRenderer());
        model.getColumn(2).setCellEditor(new DefaultCellEditor(this.intervalComboBox));
        model.getColumn(2).setCellRenderer(new ComboCellRenderer());
        model.getColumn(4).setCellEditor(new DefaultCellEditor(this.alignmentComboBox));
        model.getColumn(4).setCellRenderer(new ComboCellRenderer());
    }
}

