/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.LithologyCellRenderer;
import model2.Lithdesc;
import model2.Lithology;
import util.SB;

class TableModelLithdesc
extends AbstractTableModel {
    static final int COL_CODE = 0;
    static final int COL_DESC = 1;
    static final int COL_ABBR = 2;
    static final int COL_PATTERN = 3;
    static final int COL_GRAINSIZE = 4;
    static final int COL_SORT = 5;
    static final String[] colTitles = new String[]{"Code", "Description", "Abr.", "Pattern", "Grain Size", "Sort order"};
    static final int[] colWidths = new int[]{30, 60, 30, 40, 30, 30};
    char units = (char)77;
    Lithdesc lithdesc;
    List<Lithology> list;

    TableModelLithdesc() {
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Lithology lith = this.list.get(rowIndex);
        if (lith == null) {
            return "";
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return "" + lith.getLithID();
                }
                case 1: {
                    return lith.getDescr();
                }
                case 2: {
                    return lith.getAbr();
                }
                case 3: {
                    return lith;
                }
                case 4: {
                    return Float.valueOf(lith.getGrainSize());
                }
                case 5: {
                    return lith.getSortOrder();
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            Lithology lith = this.list.get(row);
            if (lith == null) {
                return;
            }
            switch (col) {
                case 1: {
                    lith.setDescr(obj.toString());
                    break;
                }
                case 2: {
                    lith.setAbr(obj.toString());
                    break;
                }
                case 4: {
                    lith.setGrainSize(Float.parseFloat(obj.toString()));
                    break;
                }
                case 5: {
                    lith.setSortOrder(Integer.parseInt(obj.toString()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return Lithology.class;
            }
            default: {
                return String.class;
            }
            case 5: {
                return Integer.class;
            }
            case 4: 
        }
        return Float.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    void setupTable(JTable jTable) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        jTable.getColumnModel().getColumn(3).setCellRenderer(new LithologyCellRenderer());
    }
}

