/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbugs.ComboCellRenderer;
import jsbugs.MatchAbnItem;
import jsbugs.TableModelSB;
import model2.AbnScheme;
import util.ArrowCellRenderer;
import util.SB;

class TableModelMatchAbundance
extends AbstractTableModel {
    static final int COL_DONOR_ABR = 0;
    static final int COL_DONOR_DESCRIPTION = 1;
    static final int COL_DONOR_MIN = 2;
    static final int COL_DONOR_OUTPUT = 3;
    static final int COL_DONOR_OCCS = 4;
    static final int COL_ARROW = 5;
    static final int COL_HOST_ABUNDANCE = 6;
    static final int COL_HOST_MIN = 7;
    static final int COL_HOST_RW = 8;
    static final int COL_HOST_CV = 9;
    static final int COL_HOST_QU = 10;
    static final int COL_HOST_ADDITIONAL = 11;
    static final String[] colTitles = new String[]{"Abr.", "Description", "Min", "Output", "Occs", "", "Abundance", "Min", "Rw", "Cv", "?", "+"};
    static final int[] colWidths = new int[]{15, 40, 20, 20, 20, 16, 60, 20, 20, 20, 20, 20};
    List<MatchAbnItem> data = new LinkedList<MatchAbnItem>();
    String ADDITONAL_STRING = "<additional/outside count>";
    AbnScheme dbScheme = null;
    static Boolean additional = true;
    static Boolean notAdditional = false;

    TableModelMatchAbundance() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchAbnItem item = this.data.get(rowIndex);
        if (item == null) {
            return "";
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return item.abr;
                }
                case 2: {
                    return "" + (item.min > 0 ? Integer.valueOf(item.min) : "");
                }
                case 3: {
                    return "" + (item.output > 0 ? Integer.valueOf(item.output) : "");
                }
                case 4: {
                    return item.occs;
                }
                case 1: {
                    return item.desc;
                }
                case 5: {
                    return item.dbDesc != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
                case 6: {
                    return item.dbDesc != null ? item.dbDesc : "<select>";
                }
                case 7: {
                    return item.dbDesc != null && item.dbMin > 0 ? Integer.valueOf(item.dbMin) : "";
                }
                case 8: {
                    return item.rw;
                }
                case 9: {
                    return item.cv;
                }
                case 10: {
                    return item.questionable;
                }
                case 11: {
                    return item.additional ? additional : notAdditional;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: {
                return String.class;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return Boolean.class;
            }
            case 4: 
        }
        return Integer.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        MatchAbnItem item = this.data.get(rowIndex);
        if (item == null) {
            return;
        }
        try {
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return;
                }
                case 6: {
                    item.dbDesc = (String)value;
                    item.dbMin = this.dbScheme.getIndexDescr(item.dbDesc) >= 0 ? this.dbScheme.getLowBound(this.dbScheme.getIndexDescr(item.dbDesc)) : 0;
                    if (!item.additional) break;
                    item.additional = false;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    break;
                }
                case 8: {
                    item.rw = (Boolean)value;
                    if (!item.additional) break;
                    item.additional = false;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    break;
                }
                case 9: {
                    item.cv = (Boolean)value;
                    if (!item.additional) break;
                    item.additional = false;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    break;
                }
                case 10: {
                    item.questionable = (Boolean)value;
                    if (!item.additional) break;
                    item.additional = false;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    break;
                }
                case 11: {
                    item.additional = (Boolean)value;
                    if (item.additional) {
                        item.dbDesc = this.ADDITONAL_STRING;
                        item.rw = false;
                        item.cv = false;
                        item.questionable = false;
                    } else {
                        item.dbDesc = null;
                    }
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setupTable(JTable jTable, JComboBox combo) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < colTitles.length; ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        jTable.getColumnModel().getColumn(5).setCellRenderer((TableCellRenderer)new ArrowCellRenderer());
        jTable.getColumnModel().getColumn(5).setMaxWidth(colWidths[5]);
        jTable.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(combo));
        jTable.getColumnModel().getColumn(6).setCellRenderer(new ComboCellRenderer());
        jTable.setToolTipText("Click on Database abundance entry to select matching abundance in host database scheme.");
    }
}

