/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.table.AbstractTableModel;
import jsbugs.TableModelSB;
import model2.EnvScheme;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import util.MatchData;
import util.SB;
import util.StringStatus;

class TableModelMatchAnalyses
extends AbstractTableModel {
    SBdb workspace;
    static final int COL_DONOR_SAMPLE = 0;
    static final int COL_DONOR_ANALYST = 1;
    static final int COL_DONOR_NUMBER = 2;
    static final int COL_DONOR_MODIFIED = 3;
    static final int COL_DONOR_OCCS = 4;
    static final int COL_DONOR_STATUS = 5;
    static final int COL_DONOR_NOTES = 6;
    static final int COL_DONOR_WEIGHT = 7;
    static final int COL_DONOR_COARSE = 8;
    static final int COL_DONOR_MED = 9;
    static final int COL_DONOR_FINE = 10;
    static final int COL_DONOR_FOV = 11;
    static final int COL_DONOR_PROX = 12;
    static final int COL_DONOR_DIST = 13;
    static final int COL_DONOR_SRC = 14;
    static final int COL_ARROW = 15;
    static final int COL_HOST_SAMPLE = 16;
    static final int COL_HOST_ANALYST = 17;
    static final int COL_HOST_NUMBER = 18;
    static final int COL_HOST_MODIFIED = 19;
    static final int COL_HOST_OCCS = 20;
    static final int COL_HOST_STATUS = 21;
    static final int COL_HOST_NOTES = 22;
    static final int COL_HOST_WEIGHT = 23;
    static final int COL_HOST_COARSE = 24;
    static final int COL_HOST_MED = 25;
    static final int COL_HOST_FINE = 26;
    static final int COL_HOST_FOV = 27;
    static final int COL_HOST_PROX = 28;
    static final int COL_HOST_DIST = 29;
    static final int COL_HOST_SRC = 30;
    static final String[] colTitles = new String[]{"Sample", "Analyst", "No.", "Modified", "Occs", "Status", "Notes", "Weight", "Coarse", "Medium", "Fine", "FOV", "Proximal", "Distal", "Source", "", "Sample", "Analyst", "No.", "Modified", "Occs", "Status", "Notes", "Weight", "Coarse", "Medium", "Fine", "FOV", "Proximal", "Distal", "Source"};
    static final int[] colWidths = new int[]{50, 20, 10, 40, 20, 50, 50, 20, 20, 20, 20, 20, 20, 20, 20, 16, 50, 20, 10, 40, 20, 50, 50, 20, 20, 20, 20, 20, 20, 20, 20};
    char units = (char)77;
    MatchData data = new MatchData();

    TableModelMatchAnalyses() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        Smpdtl ws = (Smpdtl)pair.getWs();
        Smpdtl db = (Smpdtl)pair.getDb();
        if (ws != null) {
            ws.getSample().displayUnits = this.units;
        }
        if (db != null) {
            db.getSample().displayUnits = this.units;
        }
        EnvScheme envScheme = null;
        try {
            if (ws != null) {
                envScheme = this.workspace.getEnvScheme(ws.getHeader().getEnvSchID());
            }
            switch (columnIndex) {
                case 0: {
                    return ws == null ? null : ws.getSample();
                }
                case 1: {
                    return ws == null ? null : new StringStatus(ws.getAnalyst(), ws.getStatus());
                }
                case 2: {
                    return ws == null ? null : new StringStatus("" + ws.getAnalyNo(), ws.getStatus());
                }
                case 3: {
                    return ws == null ? null : new StringStatus(ws.getModified() == null ? "" : SB.df.format(ws.getModified()), ws.getStatus());
                }
                case 4: {
                    return ws == null ? null : new StringStatus(ws.getOccur().size() > 0 ? "" + ws.getOccur().size() : ws.getAnalysisType().getString(), ws.getStatus());
                }
                case 5: {
                    return ws == null ? null : new StringStatus(ws.getAnalysisType().getString(), ws.getStatus());
                }
                case 6: {
                    return ws == null ? null : new StringStatus(ws.getNotes(), ws.getStatus());
                }
                case 7: {
                    return ws == null ? null : new StringStatus("" + (ws.getWeight() == 0.0f ? "" : Float.valueOf(ws.getWeight())), ws.getStatus());
                }
                case 8: {
                    return ws == null ? null : new StringStatus("" + (ws.getCoarse() == 0.0f ? "" : Float.valueOf(ws.getCoarse())), ws.getStatus());
                }
                case 9: {
                    return ws == null ? null : new StringStatus("" + (ws.getMedium() == 0.0f ? "" : Float.valueOf(ws.getMedium())), ws.getStatus());
                }
                case 10: {
                    return ws == null ? null : new StringStatus("" + (ws.getFine() == 0.0f ? "" : Float.valueOf(ws.getFine())), ws.getStatus());
                }
                case 11: {
                    return ws == null ? null : new StringStatus("" + (ws.getFOV() == 0 ? "" : Integer.valueOf(ws.getFOV())), ws.getStatus());
                }
                case 12: {
                    return ws == null ? null : new StringStatus(envScheme == null || envScheme.getTerm(ws.getProximal()).equals("<no term>") ? "" : envScheme.getTerm(ws.getProximal()), ws.getStatus());
                }
                case 13: {
                    return ws == null ? null : new StringStatus(envScheme == null || envScheme.getTerm(ws.getDistal()).equals("<no term>") ? "" : envScheme.getTerm(ws.getDistal()), ws.getStatus());
                }
                case 14: {
                    return ws == null ? null : new StringStatus(ws.getSource(), ws.getStatus());
                }
                case 15: {
                    return ws != null && db != null && ws.getStatus() == Sample.STORED ? TableModelSB.linked : TableModelSB.unlinked;
                }
                case 16: {
                    return db != null ? db.getSample().toString() : null;
                }
                case 17: {
                    return db != null ? db.getAnalyst() : null;
                }
                case 18: {
                    return db != null ? "" + db.getAnalyNo() : null;
                }
                case 19: {
                    return db == null ? null : SB.df.format(db.getModified());
                }
                case 20: {
                    return db == null ? "" : (db.getOccur().size() > 0 ? "" + db.getOccur().size() : db.getAnalysisType().getString());
                }
                case 21: {
                    return db == null ? "" : db.getAnalysisType().getString();
                }
                case 22: {
                    return db == null ? "" : db.getNotes();
                }
                case 23: {
                    return db == null ? "" : (db.getWeight() == 0.0f ? "" : Float.valueOf(db.getWeight()));
                }
                case 24: {
                    return db == null ? "" : (db.getCoarse() == 0.0f ? "" : Float.valueOf(db.getCoarse()));
                }
                case 25: {
                    return db == null ? "" : (db.getMedium() == 0.0f ? "" : Float.valueOf(db.getMedium()));
                }
                case 26: {
                    return db == null ? "" : (db.getFine() == 0.0f ? "" : Float.valueOf(db.getFine()));
                }
                case 27: {
                    return db == null ? "" : (db.getFOV() == 0 ? "" : Integer.valueOf(db.getFOV()));
                }
                case 28: {
                    if (db == null) {
                        return "";
                    }
                    if (db.getHeader().getEnvSchID() <= 0) {
                        return "";
                    }
                    if (db.getProximal() <= 0) {
                        return "";
                    }
                    return db.getDatabase().getEnvScheme(db.getHeader().getEnvSchID()).getTerm(db.getProximal());
                }
                case 29: {
                    if (db == null) {
                        return "";
                    }
                    if (db.getHeader().getEnvSchID() <= 0) {
                        return "";
                    }
                    if (db.getDistal() <= 0) {
                        return "";
                    }
                    return db.getDatabase().getEnvScheme(db.getHeader().getEnvSchID()).getTerm(db.getDistal());
                }
                default: {
                    return "";
                }
                case 30: 
            }
            return db == null ? "" : db.getSource();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return StringStatus.class;
            }
            case 15: {
                return Boolean.class;
            }
        }
        return String.class;
    }
}

