/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import model2.AnalystHeader;
import model2.EnvScheme;
import model2.SBdb;
import model2.Well;
import util.ArrowCellRenderer;
import util.MatchData;
import util.SB;
import util.SbugsStatusRenderer;
import util.StringStatus;

class TableModelMatchAnalystHeaders
extends AbstractTableModel {
    Well well;
    int rowCount = 0;
    static String[] colTitle = new String[]{"Analyst/No.", "Environment Scheme", "Abundance Scheme", "", "Analyst/No.", "Environment Scheme", "Abundance Scheme"};
    static final int COL_WS_ANALYST = 0;
    static final int COL_WS_ENVSCH = 1;
    static final int COL_WS_ABNSCH = 2;
    static final int COL_ARROW = 3;
    static final int COL_DB_ANALYST = 4;
    static final int COL_DB_ENVSCH = 5;
    static final int COL_DB_ABNSCH = 6;
    static int[] colWidths = new int[]{25, 30, 30, 16, 25, 30, 30};
    MatchData data = new MatchData();
    SBdb dbsbdb;
    SBdb wssbdb;

    TableModelMatchAnalystHeaders() {
    }

    @Override
    public int getColumnCount() {
        return colTitle.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        AnalystHeader ws = (AnalystHeader)pair.getWs();
        AnalystHeader db = (AnalystHeader)pair.getDb();
        try {
            switch (columnIndex) {
                case 0: {
                    return ws == null ? null : new StringStatus(ws.getAnalyst() + "/" + ws.getAnalyNumber(), ws.getStatus());
                }
                case 1: {
                    if (ws == null) {
                        return "";
                    }
                    return ws.getEnvSchID() <= 0 ? new StringStatus("", ws.getStatus()) : new StringStatus(this.wssbdb.getEnvScheme(ws.getEnvSchID()).getLink().toString(), ws.getStatus());
                }
                case 2: {
                    if (ws == null) {
                        return null;
                    }
                    return ws.getAbnSchID() <= 0 ? new StringStatus("", ws.getStatus()) : new StringStatus(this.wssbdb.getAbnScheme(ws.getAbnSchID(), false).getLink().toString(), ws.getStatus());
                }
                case 3: {
                    if (ws == null) {
                        return false;
                    }
                    return true;
                }
                case 4: {
                    return db == null ? "" : db.getAnalyst() + "/" + db.getAnalyNumber();
                }
                case 5: {
                    if (db == null) {
                        return "";
                    }
                    if (db.getEnvSchID() > 0) {
                        EnvScheme sch = this.dbsbdb.getEnvScheme(db.getEnvSchID());
                        if (sch != null) {
                            return sch.toString();
                        }
                        return "Error getting scheme: " + db.getEnvSchID();
                    }
                    return "";
                }
                case 6: {
                    return db == null ? "" : this.dbsbdb.getAbnScheme(db.getAbnSchID(), false);
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return StringStatus.class;
            }
            case 4: 
            case 5: 
            case 6: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public void setupTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        columnModel.getColumn(3).setMaxWidth(colWidths[3]);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitle[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
    }
}

