/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbugs.ComboCellRenderer;
import jsbugs.TableModelMatchSamples;
import jsbugs.TableModelSB;
import model2.SBdb;
import model2.Userdef;
import util.ArrowCellRenderer;
import util.SB;
import util.SbugsStatusRenderer;

class TableModelMatchAnalysts
extends AbstractTableModel {
    private static final String[] colTitle = new String[]{"Abr.", "Name", "", "Abr.", "Name"};
    static final int COL_DONOR_ABR = 0;
    static final int COL_DONOR_NAME = 1;
    static final int COL_ARROW = 2;
    static final int COL_HOST_ABR = 3;
    static final int COL_HOST_NAME = 4;
    private static final int[] colWidths = new int[]{50, 150, 16, 50, 150};
    private final JComboBox analystComboBox = new JComboBox();
    SBdb db;
    SBdb ws;
    Userdef[] users;

    TableModelMatchAnalysts() {
    }

    @Override
    public int getColumnCount() {
        return colTitle.length;
    }

    @Override
    public int getRowCount() {
        if (this.users == null) {
            return 0;
        }
        return this.users.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.users == null) {
            return null;
        }
        try {
            Userdef user = this.users[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return user;
                }
                case 1: {
                    return user.getName() != null ? user.getName() : "";
                }
                case 3: {
                    return user.getLink() == null ? "<select>" : user.getLink().getAbr();
                }
                case 4: {
                    return user.getLink() == null ? null : user.getLink().getName();
                }
                case 2: {
                    return user.getLink() != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Userdef.class;
            }
            case 3: 
            case 4: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            switch (col) {
                default: {
                    break;
                }
                case 3: {
                    Userdef user = this.users[row];
                    Userdef dbUser = this.db.getUser((String)obj);
                    if (dbUser != null) {
                        user.setLink(dbUser);
                        break;
                    }
                    user.setLink(null);
                    break;
                }
            }
        }
        catch (Exception pe) {
            pe.printStackTrace();
        }
    }

    void refreshUserCombo(SBdb db) throws SQLException {
        this.analystComboBox.removeAllItems();
        Iterator it = db.getUsers().iterator();
        LinkedList<String> userAbrs = new LinkedList<String>();
        while (it.hasNext()) {
            userAbrs.add(((Userdef)it.next()).getAbr());
        }
        Collections.sort(userAbrs);
        for (String abr : userAbrs) {
            this.analystComboBox.addItem(abr);
        }
        this.analystComboBox.insertItemAt("", 0);
    }

    void setupTable(JTable table, SBdb ws, SBdb db) throws SQLException {
        try {
            this.users = ws.getUsers().toArray(new Userdef[0]);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.db = db;
        this.ws = ws;
        this.refreshUserCombo(db);
        for (int i = 0; i < colTitle.length; ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(colTitle[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        table.getColumnModel().getColumn(2).setMaxWidth(TableModelMatchSamples.colWidths[2]);
        table.setDefaultRenderer(Userdef.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(this.analystComboBox));
        table.getColumnModel().getColumn(3).setCellRenderer(new ComboCellRenderer());
        SB.setTableHeaderBold((JTable)table);
        table.setToolTipText("Click on blank database Abbreviation to select");
    }
}

