/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.table.AbstractTableModel;
import model2.Biocom;
import model2.Sample;
import util.MatchData;
import util.StringStatus;

class TableModelMatchBiocom
extends AbstractTableModel {
    static final int COL_WS_SAMPLE_FROM = 0;
    static final int COL_WS_SAMPLE_TO = 1;
    static final int COL_WS_ANALYST = 2;
    static final int COL_WS_TEXT = 3;
    static final int COL_ARROW = 4;
    static final int COL_DB_SAMPLE_FROM = 5;
    static final int COL_DB_SAMPLE_TO = 6;
    static final int COL_DB_ANALYST = 7;
    static final int COL_DB_TEXT = 8;
    static final String[] colTitles = new String[]{"From", "To", "Analyst", "Text", "", "From", "To", "Analyst", "Text"};
    static final int[] colWidths = new int[]{30, 30, 20, 70, 16, 30, 30, 20, 70};
    char units = (char)77;
    MatchData data = new MatchData();

    TableModelMatchBiocom() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        Biocom ws = (Biocom)pair.getWs();
        Biocom db = (Biocom)pair.getDb();
        if (ws != null) {
            ws.getTopSample().displayUnits = this.units;
            if (ws.getBaseSample() != null) {
                ws.getBaseSample().displayUnits = this.units;
            }
        }
        if (db != null) {
            db.getTopSample().displayUnits = this.units;
            if (db.getBaseSample() != null) {
                db.getBaseSample().displayUnits = this.units;
            }
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return ws == null ? null : ws.getTopSample();
                }
                case 1: {
                    return ws == null ? null : ws.getBaseSample();
                }
                case 2: {
                    return ws == null ? null : new StringStatus(ws.getAnalystString(), ws.getStatus());
                }
                case 3: {
                    return ws == null ? null : new StringStatus(ws.getText(), ws.getStatus());
                }
                case 4: {
                    return new Boolean(ws != null && db != null && ws.getStatus() == Sample.STORED);
                }
                case 5: {
                    return db != null ? db.getTopSample().toString() : null;
                }
                case 6: {
                    return db != null && db.getBaseSample() != null ? db.getBaseSample().toString() : null;
                }
                case 7: {
                    return db != null ? db.getAnalystString() : null;
                }
                case 8: {
                    return db != null ? db.getText() : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return StringStatus.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return String.class;
    }
}

