/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import jsbugs.FrameJsbugs;
import model2.Category;
import model2.SBdb;
import util.ArrowCellRenderer;

class TableModelMatchCategories
extends AbstractTableModel {
    Category[] donorCat;
    int[] occs;
    Category[] hostCat;
    String[] hostDescription;
    static String[] colTitles = new String[]{"Donor Cat.", "Occs", "", "Host Cat.", "Name"};
    static int[] colWidths = new int[]{40, 30, 16, 40, 80};
    static final int COL_DONORID = 0;
    static final int COL_OCCS = 1;
    static final int COL_ARROW = 2;
    static final int COL_HOSTID = 3;
    static final int COL_NAME = 4;
    JComboBox categoryComboBox = new JComboBox();
    SBdb db;

    TableModelMatchCategories() {
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.donorCat == null) {
            return 0;
        }
        return this.donorCat.length;
    }

    public void setSize(int i) {
        this.donorCat = new Category[i];
        this.occs = new int[i];
        this.hostCat = new Category[i];
        this.hostDescription = new String[i];
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.donorCat[row].getMnem();
            }
            case 1: {
                return new Integer(this.occs[row]);
            }
            case 2: {
                return new Boolean(this.hostCat[row] != null);
            }
            case 3: {
                return this.hostCat[row];
            }
            case 4: {
                return this.hostCat[row] != null ? this.hostCat[row].getName() : null;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            default: {
                break;
            }
            case 3: {
                try {
                    String mnem = (String)obj;
                    if (mnem == null) {
                        this.hostCat[row] = null;
                        break;
                    }
                    this.hostCat[row] = this.db.getCategory(mnem);
                    break;
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.db);
                }
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 3: 
        }
        return true;
    }

    public void setupTable(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int i = 0; i < colTitles.length; ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        TableColumn hostIDColumn = table.getColumnModel().getColumn(3);
        hostIDColumn.setCellEditor(new DefaultCellEditor(this.categoryComboBox));
        hostIDColumn.setCellRenderer(new ComboCellRenderer());
        columnModel.getColumn(2).setMaxWidth(colWidths[2]);
        columnModel.getColumn(2).setCellRenderer((TableCellRenderer)new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }
}

