/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import model2.CoredInterval;
import model2.Cores;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.StringStatus;

class TableModelMatchCores
extends AbstractTableModel {
    static final int COL_DONOR_TOP = 0;
    static final int COL_DONOR_BASE = 1;
    static final int COL_DONOR_NUMBER = 2;
    static final int COL_ARROW = 3;
    static final int COL_HOST_TOP = 4;
    static final int COL_HOST_BASE = 5;
    static final int COL_HOST_NUMBER = 6;
    static final String[] colTitles = new String[]{"Top", "Base", "Number", "", "Top", "Base", "Number"};
    static final int[] colWidths = new int[]{40, 40, 30, 16, 40, 40, 30};
    char units;
    MatchData data = new MatchData();

    TableModelMatchCores() {
    }

    void init(Cores ws, Cores db) throws SBException, SQLException {
        this.data.init(ws.getList(), db != null ? db.getList() : null);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        CoredInterval ws = (CoredInterval)pair.getWs();
        CoredInterval db = (CoredInterval)pair.getDb();
        switch (columnIndex) {
            case 0: {
                return ws != null ? new StringStatus(SB.floatString((double)SB.convFromM((double)ws.getTopDepth(), (char)this.units), (int)2), ws.getStatus()) : null;
            }
            case 1: {
                return ws != null ? new StringStatus(SB.floatString((double)SB.convFromM((double)ws.getBaseDepth(), (char)this.units), (int)2), ws.getStatus()) : null;
            }
            case 2: {
                return ws != null ? new StringStatus(ws.getCorenum(), ws.getStatus()) : null;
            }
            case 3: {
                return new Boolean(ws != null && db != null && ws.getStatus() == SbugsStatus.STORED);
            }
            case 4: {
                return db != null ? SB.getDepthString((double)db.getTopDepth(), (char)this.units, (int)2) : "";
            }
            case 5: {
                return db != null ? SB.getDepthString((double)db.getBaseDepth(), (char)this.units, (int)2) : "";
            }
            case 6: {
                return db != null ? db.getCorenum() : "";
            }
        }
        return "";
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return StringStatus.class;
            }
            case 4: 
            case 5: 
            case 6: {
                return String.class;
            }
            default: {
                return CoredInterval.class;
            }
            case 3: 
        }
        return Boolean.class;
    }
}

