/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import model2.EnvScheme;
import util.ArrowCellRenderer;
import util.ColorRenderer;
import util.SB;
import util.SbugsStatusRenderer;
import util.StringStatus;

class TableModelMatchEnvScheme
extends AbstractTableModel {
    static final int COL_DONOR_ENV = 0;
    static final int COL_DONOR_COLOUR = 1;
    static final int COL_DONOR_OCCS = 2;
    static final int COL_ARROW = 3;
    static final int COL_HOST_ENV = 4;
    static final int COL_HOST_COLOUR = 5;
    static final String[] colTitles = new String[]{"Environment", "Colour", "Occs", "", "Environment", "Colour"};
    static final int[] colWidths = new int[]{120, 20, 20, 16, 120, 20};
    EnvScheme scheme;
    JComboBox envComboBox = new JComboBox();

    TableModelMatchEnvScheme() {
    }

    @Override
    public int getRowCount() {
        if (this.scheme == null) {
            return 0;
        }
        return this.scheme.getNClasses();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            switch (columnIndex) {
                case 0: {
                    return new StringStatus(this.scheme.getTerm(rowIndex + 1), this.scheme.getStatus());
                }
                case 2: {
                    return new StringStatus("" + this.scheme.getNoccs(rowIndex + 1), this.scheme.getStatus());
                }
                case 1: {
                    return this.scheme.getColour(rowIndex + 1);
                }
                case 3: {
                    return new Boolean(this.scheme.getLinkTerm(rowIndex + 1) != null);
                }
                case 4: {
                    return this.scheme.getLinkTerm(rowIndex + 1);
                }
                case 5: {
                    return this.scheme.getLinkColour(rowIndex + 1);
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 2: {
                return StringStatus.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: {
                return String.class;
            }
            case 1: 
            case 5: {
                return Color.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            case 4: {
                try {
                    String termName;
                    if (obj == null || this.scheme.getLink() == null || (termName = (String)obj).length() <= 0) break;
                    this.scheme.setLinkTerm(row + 1, termName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 4: 
        }
        return true;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(3).setMaxWidth(colWidths[3]);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        columnModel.getColumn(4).setCellEditor(new DefaultCellEditor(this.envComboBox));
        columnModel.getColumn(4).setCellRenderer(new ComboCellRenderer());
    }
}

