/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.TableModelSB;
import model2.SBEvent;
import util.ArrowCellRenderer;
import util.SB;
import util.SbugsStatusRenderer;
import util.StringStatus;

class TableModelMatchEvents
extends AbstractTableModel {
    static final int COL_WS_EVENT = 0;
    static final int COL_WS_TAXON = 1;
    static final int COL_WS_PAIRED = 2;
    static final int COL_WS_GEN = 3;
    static final int COL_WS_DESC = 4;
    static final int COL_ARROW = 5;
    static final int COL_DB_EVENT = 6;
    static final int COL_DB_TAXON = 7;
    static final int COL_DB_PAIRED = 8;
    static final int COL_DB_GEN = 9;
    static final int COL_DB_DESC = 10;
    static final int COL_DB_OCCS = 11;
    static final String[] colTitles = new String[]{"Event", "Taxon", "Type", "Flag", "Desc", "", "Event", "Taxon", "Type", "Flag", "Desc", "Occs"};
    static final int[] colWidths = new int[]{100, 60, 30, 20, 50, 16, 100, 60, 30, 20, 50, 30};
    List<SBEvent> data = new LinkedList<SBEvent>();

    TableModelMatchEvents() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SBEvent ws = this.data.get(rowIndex);
        SBEvent db = ws.getLink();
        try {
            switch (columnIndex) {
                case 0: {
                    return ws != null ? new StringStatus(ws.getDictionaryName(), ws.getStatus()) : null;
                }
                case 1: {
                    Color status = SBEvent.NOTSTORED;
                    if (ws.getTaxon() == null) {
                        status = SBEvent.STORED;
                    } else if (ws.getTaxon().getLink() != null) {
                        status = SBEvent.STORED;
                    }
                    return ws != null && ws.getTaxon() != null ? new StringStatus(ws.getTaxon().toString(), status) : null;
                }
                case 2: {
                    return ws != null ? new StringStatus(ws.isSingle() ? "Single" : "Paired", ws.getStatus()) : null;
                }
                case 3: {
                    return ws != null ? new StringStatus(ws.isGenerate() ? "Yes" : "No", ws.getStatus()) : null;
                }
                case 4: {
                    return ws != null ? new StringStatus(ws.getEvDesc() != null ? ws.getEvDesc() : "", ws.getStatus()) : null;
                }
                case 5: {
                    return ws != null && db != null && ws.getStatus() == SBEvent.STORED ? TableModelSB.linked : TableModelSB.unlinked;
                }
                case 6: {
                    return db != null ? db.getDictionaryName() : null;
                }
                case 7: {
                    return db != null && db.getTaxon() != null ? db.getTaxon().toString() : "";
                }
                case 8: {
                    return db != null ? (db.isSingle() ? "Single" : "Paired") : "";
                }
                case 9: {
                    return db != null ? (db.isGenerate() ? "Yes" : "No") : "";
                }
                case 10: {
                    return db != null ? db.getEvDesc() : null;
                }
                case 11: {
                    return db != null ? Integer.valueOf(db.getNoccs(false)) : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return StringStatus.class;
            }
            case 5: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(5).setMaxWidth(colWidths[5]);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }
}

