/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import model2.Taxon;
import util.ArrowCellRenderer;
import util.ColorRenderer;
import util.MatchData;
import util.SB;
import util.SbugsStatusRenderer;
import util.SortEntry;
import util.StringStatus;

class TableModelMatchGroup
extends AbstractTableModel {
    static final int COL_WSCAT = 0;
    static final int COL_WSTAXON = 1;
    static final int COL_WSIMAGES = 2;
    static final int COL_ARROW = 3;
    static final int COL_DBCAT = 4;
    static final int COL_DBTAXON = 5;
    static final int COL_DB_IMAGES = 6;
    static final String[] colTitles = new String[]{"Cat.", "Taxon", "Type Images", " ", "Cat.", "Taxon", "Images"};
    static final int[] colWidths = new int[]{20, 130, 30, 16, 20, 130, 30};
    MatchData<MatchGroupTaxon> data = new MatchData();
    Boolean linked = true;
    Boolean unlinked = false;

    TableModelMatchGroup() {
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        MatchData.MatchPair pair = this.data.get(row);
        MatchGroupTaxon mgWsTaxon = (MatchGroupTaxon)pair.getWs();
        Taxon wsLinkedTaxon = mgWsTaxon == null ? null : mgWsTaxon.taxon.getLink();
        MatchGroupTaxon mgDbTaxon = (MatchGroupTaxon)pair.getDb();
        Taxon dbTaxon = mgDbTaxon == null ? null : mgDbTaxon.taxon;
        switch (col) {
            case 0: {
                if (wsLinkedTaxon == null) {
                    return null;
                }
                return new StringStatus(wsLinkedTaxon.getCatMnem(), dbTaxon != null ? Taxon.STORED : Taxon.NOTSTORED);
            }
            case 1: {
                if (wsLinkedTaxon == null) {
                    return null;
                }
                return new StringStatus(wsLinkedTaxon.toString(true, false, false), dbTaxon != null ? Taxon.STORED : Taxon.NOTSTORED);
            }
            case 2: {
                if (wsLinkedTaxon == null) {
                    return null;
                }
                return mgWsTaxon.taxon.getNwsImages();
            }
            case 5: {
                if (dbTaxon == null) {
                    return null;
                }
                return dbTaxon.toString(true, false, false);
            }
            case 3: {
                return wsLinkedTaxon != null && dbTaxon != null ? this.linked : this.unlinked;
            }
            case 4: {
                if (dbTaxon != null) {
                    return dbTaxon.getCatMnem();
                }
                return null;
            }
            case 6: {
                if (dbTaxon != null) {
                    int imageCount = 0;
                    try {
                        imageCount = dbTaxon.getImageSetCount(false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (imageCount > 0) {
                        return "" + imageCount;
                    }
                    return null;
                }
                return null;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            case 0: 
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: 
        }
        return false;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 4: {
                return String.class;
            }
            case 2: 
            case 5: 
            case 6: {
                return String.class;
            }
            case 0: 
            case 1: {
                return StringStatus.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(3).setMaxWidth(colWidths[3]);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
    }

    static class MatchGroupTaxon
    implements SortEntry {
        Taxon taxon;

        public MatchGroupTaxon(Taxon taxon) {
            this.taxon = taxon;
        }

        public String getSortEntry() {
            if (this.taxon == null) {
                System.out.println("Taxon null in MatchGroupWsTaxon");
                return null;
            }
            if (this.taxon.getLink() == null) {
                return this.taxon.getSortEntry();
            }
            return this.taxon.getLink().getSortEntry();
        }

        public boolean isFuncEquivalent(SortEntry e) {
            if (this.taxon == null) {
                System.out.println("Taxon null in MatchGroupWsTaxon");
                return false;
            }
            if (this.taxon.getLink() == null) {
                return this.taxon.isFuncEquivalent(e);
            }
            return this.taxon.getLink().isFuncEquivalent(e);
        }
    }
}

