/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import model2.IGDScheme;
import model2.Surface;
import util.ArrowCellRenderer;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;

class TableModelMatchIGDSchemeSurfaces
extends AbstractTableModel {
    static final int COL_WS_NAME = 0;
    static final int COL_WS_TYPE = 1;
    static final int COL_WS_AGE = 2;
    static final int COL_ARROW = 3;
    static final int COL_DB_NAME = 4;
    static final int COL_DB_TYPE = 5;
    static final int COL_DB_AGE = 6;
    static final int COL_HOST_OCCS = 7;
    String[] colTitles = new String[]{"Surface", "Type", "Age", "", "Surface", "Type", "Age", "Occs"};
    int[] colWidths = new int[]{100, 30, 30, 10, 16, 100, 30, 30};
    IGDScheme scheme;
    MatchData<Surface> data = new MatchData();

    TableModelMatchIGDSchemeSurfaces() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        Surface ws = (Surface)pair.getWs();
        Surface db = (Surface)pair.getDb();
        try {
            switch (columnIndex) {
                case 0: {
                    return ws != null ? new StringStatus(ws.getName(), ws.getStatus()) : null;
                }
                case 1: {
                    return ws != null ? new StringStatus(ws.getTypeString(), ws.getStatus()) : null;
                }
                case 2: {
                    return ws != null ? new StringStatus(SB.floatString((double)ws.getAge(), (int)3), ws.getStatus()) : null;
                }
                case 3: {
                    return new Boolean(ws != null && db != null);
                }
                case 4: {
                    return db != null ? db.getName() : null;
                }
                case 5: {
                    return db != null ? db.getTypeString() : "";
                }
                case 6: {
                    return db != null ? SB.floatString((double)db.getAge(), (int)3) : "";
                }
                case 7: {
                    return db != null ? Integer.valueOf(db.getNoccs(false)) : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return StringStatus.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
        }
        columnModel.getColumn(3).setMaxWidth(this.colWidths[3]);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }

    void linkSurfaces() throws SQLException, SBException {
        if (this.scheme.getLink() == null) {
            return;
        }
        for (Surface surface : this.scheme.getSurfaces()) {
            if (surface.getLink() != null && surface.getLink().getSchID() == this.scheme.getLink().getID() && this.scheme.getLink().findUnit(surface.getLink().getSurfaceID()) != null) continue;
            surface.setLink(this.scheme.getLink().findSurface(surface.getName(), surface.getType()));
        }
        this.scheme.updateStatus();
    }
}

