/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import util.ArrowCellRenderer;
import util.ColorRenderer;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;

class TableModelMatchIGDSchemeUnits
extends AbstractTableModel {
    static final int COL_DONOR_UNIT = 0;
    static final int COL_DONOR_HIER = 1;
    static final int COL_DONOR_TOP = 2;
    static final int COL_DONOR_BASE = 3;
    static final int COL_DONOR_ABR = 4;
    static final int COL_DONOR_COLOUR = 5;
    static final int COL_ARROW = 6;
    static final int COL_HOST_UNIT = 7;
    static final int COL_HOST_HIER = 8;
    static final int COL_HOST_TOP = 9;
    static final int COL_HOST_BASE = 10;
    static final int COL_HOST_ABR = 11;
    static final int COL_HOST_COLOUR = 12;
    static final int COL_HOST_OCCS = 13;
    static final String[] colTitles = new String[]{"Unit", "Hierarchy", "Top Age", "Base Age", "Abr.", "Colour", "", "Unit", "Hierarchy", "Top Age", "Base Age", "Abr.", "Colour", "Occs"};
    static final int[] colWidths = new int[]{100, 60, 50, 50, 30, 50, 16, 100, 60, 50, 50, 30, 50, 30};
    IGDScheme scheme;
    MatchData<IGDUnit> data = new MatchData();

    TableModelMatchIGDSchemeUnits() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        IGDUnit ws = (IGDUnit)pair.getWs();
        IGDUnit db = (IGDUnit)pair.getDb();
        try {
            switch (columnIndex) {
                case 0: {
                    return ws != null ? new StringStatus(ws.getName(), ws.getStatus()) : null;
                }
                case 1: {
                    return ws != null ? new StringStatus(IGDIntervalZone.getHierName((int)this.scheme.getIGDType(), (int)ws.getHier(), (boolean)true), ws.getStatus()) : null;
                }
                case 2: {
                    return ws != null ? new StringStatus(SB.floatString((double)ws.getUage(), (int)3), ws.getStatus()) : null;
                }
                case 3: {
                    return ws != null ? new StringStatus(SB.floatString((double)ws.getLage(), (int)3), ws.getStatus()) : null;
                }
                case 5: {
                    return ws != null ? ws.getColour() : null;
                }
                case 4: {
                    return ws != null ? new StringStatus(ws.getAbr() != null ? ws.getAbr() : "", ws.getStatus()) : null;
                }
                case 6: {
                    return new Boolean(ws != null && db != null);
                }
                case 7: {
                    return db != null ? db.getName() : null;
                }
                case 11: {
                    return db != null ? db.getAbr() : "";
                }
                case 8: {
                    return db != null ? IGDIntervalZone.getHierName((int)this.scheme.getIGDType(), (int)db.getHier(), (boolean)true) : null;
                }
                case 9: {
                    return db != null ? SB.floatString((double)db.getUage(), (int)3) : "";
                }
                case 10: {
                    return db != null ? SB.floatString((double)db.getLage(), (int)3) : "";
                }
                case 12: {
                    return db != null ? db.getColour() : null;
                }
                case 13: {
                    return db != null ? Integer.valueOf(db.getNoccs(false)) : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return StringStatus.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 5: 
            case 12: {
                return Color.class;
            }
        }
        return String.class;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(6).setMaxWidth(colWidths[6]);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }

    void linkUnits() throws SQLException, SBException {
        if (this.scheme.getLink() == null) {
            return;
        }
        for (IGDUnit unit : this.scheme.getUnits()) {
            if (unit.getLink() != null && unit.getLink().getSchID() == this.scheme.getLink().getID() && this.scheme.getLink().findUnit(unit.getLink().getUnitID()) != null) continue;
            unit.setLink(this.scheme.getLink().findUnit(unit.getName()));
        }
        this.scheme.updateStatus();
    }
}

