/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import jsbugs.TableModelSB;
import model2.IGDScheme;
import model2.SBdb;
import model2.SQPick;
import model2.Surface;
import model2.Well;
import model2.WellInterp;
import util.ArrowCellRenderer;
import util.DoubleStatus;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;

public class TableModelMatchIGDSurfaces
extends AbstractTableModel {
    static final int COL_DONOR_NAME = 0;
    static final int COL_DONOR_TYPE = 1;
    static final int COL_DONOR_AGE = 2;
    static final int COL_DONOR_OCCS = 3;
    static final int COL_ARROW = 4;
    static final int COL_HOST_NAME = 5;
    static final int COL_HOST_TYPE = 6;
    static final int COL_HOST_AGE = 7;
    String[] colTitles = new String[]{"Surface", "Type", "Age", "Occs", "", "Surface", "Type", "Age"};
    int[] colWidths = new int[]{100, 30, 30, 10, 16, 100, 30, 30};
    char units = (char)77;
    IGDScheme wsScheme = null;
    LinkedList<Surface> surfaces = new LinkedList();

    @Override
    public int getRowCount() {
        return this.surfaces.size();
    }

    @Override
    public int getColumnCount() {
        return this.colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Surface surface = this.surfaces.get(rowIndex);
        try {
            switch (columnIndex) {
                case 2: {
                    return new DoubleStatus(Double.valueOf(surface.getAge()), surface.getStatus());
                }
                case 0: {
                    return new StringStatus(surface.getName(), surface.getStatus());
                }
                case 1: {
                    return new StringStatus(surface.getTypeString(), surface.getStatus());
                }
                case 3: {
                    return surface.getNoccs(false);
                }
                case 4: {
                    return surface.getLink() != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
                case 7: {
                    return surface.getLink() != null ? Double.valueOf(surface.getLink().getAge()) : null;
                }
                case 5: {
                    return surface.getLink() != null ? surface.getLink() : null;
                }
                case 6: {
                    return surface.getLink() != null ? surface.getLink().getTypeString() : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 2: {
                return DoubleStatus.class;
            }
            case 0: 
            case 1: {
                return StringStatus.class;
            }
            case 7: {
                return Double.class;
            }
            case 5: {
                return Surface.class;
            }
            case 3: 
            case 6: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 5: 
        }
        return true;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            case 5: {
                try {
                    Surface selected = this.surfaces.get(row);
                    Surface surface = obj != null ? (Surface)obj : null;
                    selected.setLink(surface);
                    this.wsScheme.updateStatus();
                    this.wsScheme.notifyObservers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    void setUpTable(JTable table, JComboBox combo) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
        }
        columnModel.getColumn(4).setMaxWidth(this.colWidths[4]);
        columnModel.getColumn(5).setCellEditor(new DefaultCellEditor(combo));
        columnModel.getColumn(5).setCellRenderer(new ComboCellRenderer());
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(DoubleStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }

    void setSurfaces(IGDScheme scheme, SBdb ws) throws SBException, SQLException {
        int igdType = scheme.getIGDType();
        if (igdType != 10) {
            throw new SBException("IGD type not sequence in TableModelMatchSurfaces.setSurfaces");
        }
        if (scheme == null) {
            throw new SBException("No workspace scheme available for this data type: " + igdType);
        }
        this.wsScheme = scheme;
        this.surfaces = new LinkedList();
        for (Surface surface : scheme.getSurfaces()) {
            surface.setNoccs(0);
        }
        Iterator it = ws.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = (Well)it.next();
            Iterator iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = (WellInterp)iit.next();
                List picks = interp.getSQPicks();
                for (SQPick pick : picks) {
                    Surface s = pick.getSurface();
                    if (!scheme.getSurfaces().contains(s)) continue;
                    s.setNoccs(s.getNoccs(false) + 1);
                    if (this.surfaces.contains(s)) continue;
                    this.surfaces.add(s);
                }
            }
        }
        scheme.updateStatus();
    }

    void linkSurfaces(IGDScheme wsScheme) throws SQLException, SBException {
        if (wsScheme.getLink() == null) {
            return;
        }
        for (Surface surface : this.surfaces) {
            String surfaceName = surface.getName();
            Surface dbSurface = wsScheme.getLink().findSurface(surfaceName, surface.getType());
            if (surface == null && surfaceName.contains("_")) {
                dbSurface = wsScheme.getLink().findSurface(surfaceName.replace("_", " "), surface.getType());
            }
            surface.setLink(dbSurface);
        }
        wsScheme.updateStatus();
    }
}

