/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import util.ArrowCellRenderer;
import util.DoubleStatus;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;

public class TableModelMatchIGDUnits
extends AbstractTableModel {
    static final int COL_DONOR_UNIT = 0;
    static final int COL_DONOR_HIER = 1;
    static final int COL_DONOR_ABR = 2;
    static final int COL_DONOR_TOP = 3;
    static final int COL_DONOR_BASE = 4;
    static final int COL_DONOR_OCCS = 5;
    static final int COL_ARROW = 6;
    static final int COL_HOST_UNIT = 7;
    static final int COL_HOST_HIER = 8;
    static final int COL_HOST_ABR = 9;
    static final int COL_HOST_TOP = 10;
    static final int COL_HOST_BASE = 11;
    static final String[] colTitles = new String[]{"Unit", "Hier.", "Abr.", "Top", "Base", "Occs.", "", "Database", "Hier.", "Abr.", "Top", "Base"};
    static final int[] colWidths = new int[]{140, 40, 20, 30, 30, 20, 16, 100, 40, 20, 30, 30};
    List<IGDUnit> list = new LinkedList<IGDUnit>();
    int igdType;
    IGDScheme wsScheme = null;

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IGDUnit unit = this.list.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    return new StringStatus(unit.toString(), unit.getStatus());
                }
                case 1: {
                    return new StringStatus(IGDIntervalZone.getHierName((int)this.igdType, (int)unit.getHier(), (boolean)true), unit.getStatus());
                }
                case 2: {
                    return new StringStatus(unit.getAbr(), unit.getStatus());
                }
                case 5: {
                    return new Integer(unit.getNoccs(false));
                }
                case 3: {
                    return new DoubleStatus(Double.valueOf(unit.getUage()), unit.getStatus());
                }
                case 4: {
                    return new DoubleStatus(Double.valueOf(unit.getLage()), unit.getStatus());
                }
                case 6: {
                    return new Boolean(unit.getLink() != null);
                }
                case 7: {
                    return unit.getLink() != null ? unit.getLink() : null;
                }
                case 8: {
                    return unit.getLink() != null ? IGDIntervalZone.getHierName((int)this.igdType, (int)unit.getLink().getHier(), (boolean)true) : null;
                }
                case 10: {
                    return unit.getLink() != null ? Double.valueOf(unit.getLink().getUage()) : null;
                }
                case 11: {
                    return unit.getLink() != null ? Double.valueOf(unit.getLink().getLage()) : null;
                }
                case 9: {
                    return unit.getLink() != null ? unit.getLink().getAbr() : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            case 7: {
                try {
                    IGDUnit selected = this.list.get(row);
                    IGDUnit unit = obj != null ? (IGDUnit)obj : null;
                    selected.setLink(unit);
                    this.wsScheme.updateStatus();
                    this.wsScheme.notifyObservers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return StringStatus.class;
            }
            case 3: 
            case 4: {
                return DoubleStatus.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 7: {
                return IGDUnit.class;
            }
            case 10: 
            case 11: {
                return Double.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 7: {
                return true;
            }
        }
        return false;
    }

    void linkUnits(IGDScheme scheme) throws SQLException, SBException {
        if (scheme.getLink() == null) {
            return;
        }
        for (IGDUnit unit : this.list) {
            unit.setLink(scheme.getLink().findUnit(unit.getName()));
        }
        scheme.updateStatus();
    }

    void setUpTable(JTable table, boolean isEditable, JComboBox combo) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        columnModel.getColumn(6).setMaxWidth(colWidths[6]);
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(7).setCellEditor(new DefaultCellEditor(combo));
        columnModel.getColumn(7).setCellRenderer(new ComboCellRenderer());
        SbugsStatusRenderer renderer = new SbugsStatusRenderer();
        renderer.setAlignmentX(0.0f);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)renderer);
        table.setDefaultRenderer(DoubleStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }

    void setUnits(JDialog parent, IGDScheme scheme, SBdb ws) throws SBException, SQLException {
        this.list.clear();
        this.igdType = scheme.getIGDType();
        if (this.igdType == 0) {
            throw new SBException("IGD type zero in units table setup");
        }
        if (scheme == null) {
            throw new SBException("No workspace scheme available for this data type: " + this.igdType);
        }
        this.wsScheme = scheme;
        for (IGDUnit unit : scheme.getUnits()) {
            unit.setNoccs(0);
        }
        Iterator it = ws.getProject(0).getWellIterator();
        boolean warnUnits = false;
        while (it.hasNext()) {
            Well well = (Well)it.next();
            Iterator iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = (WellInterp)iit.next();
                List igdList = interp.getIGDList(this.igdType, scheme.getID());
                for (IGDIntervalZone zone : igdList) {
                    int lowUnit;
                    int uppUnit = zone.getUppZone();
                    if (uppUnit > 0) {
                        IGDUnit unit = scheme.findUnit(uppUnit);
                        if (unit != null) {
                            unit.setNoccs(unit.getNoccs(false) + 1);
                            if (!this.list.contains(unit)) {
                                this.list.add(unit);
                            }
                        } else {
                            System.out.println("Unit null for unit ID: " + uppUnit + " zone: " + zone);
                            zone.setUppZone(0);
                            warnUnits = true;
                        }
                    }
                    if ((lowUnit = zone.getLowZone()) <= 0 || lowUnit == uppUnit) continue;
                    IGDUnit unit = scheme.findUnit(lowUnit);
                    if (unit != null) {
                        unit.setNoccs(unit.getNoccs(false) + 1);
                        if (this.list.contains(unit)) continue;
                        this.list.add(unit);
                        continue;
                    }
                    System.out.println("Unit null for unit ID: " + lowUnit + " zone: " + zone);
                    zone.setLowZone(0);
                    warnUnits = true;
                }
            }
        }
        scheme.updateStatus();
        if (warnUnits) {
            JOptionPane.showMessageDialog(parent, "Warning: units found in some well intervals which are not found in scheme assigned to them.\nUnit/Scheme linkage ignored in these cases.", parent.getTitle(), 2);
        }
    }
}

