/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.table.AbstractTableModel;
import jsbugs.TableModelSB;
import model2.LithBase;
import model2.LithInterval;
import model2.LithQualifier;
import model2.WsWell;
import util.DoubleStatus;
import util.MatchData;
import util.SB;
import util.StringStatus;

class TableModelMatchIntLith
extends AbstractTableModel {
    static final int COL_DONOR_TOP = 0;
    static final int COL_DONOR_BASE = 1;
    static final int COL_DONOR_LITH = 2;
    static final int COL_ARROW = 3;
    static final int COL_HOST_TOP = 4;
    static final int COL_HOST_BASE = 5;
    static final int COL_HOST_LITH = 6;
    static final String[] colTitles = new String[]{"Top", "Base", "Lithology", "", "Top", "Base", "Lithology"};
    static final int[] colWidths = new int[]{40, 40, 60, 16, 40, 40, 60};
    char units = (char)77;
    WsWell well;
    MatchData data = new MatchData();

    TableModelMatchIntLith() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        LithBase ws = (LithBase)pair.getWs();
        LithBase db = (LithBase)pair.getDb();
        try {
            switch (columnIndex) {
                case 0: {
                    return ws == null ? null : new StringStatus(SB.floatString((double)SB.convFromM((double)ws.getTopDepth(), (char)this.units, (char)this.well.getType()), (int)2), ws.getStatus());
                }
                case 1: {
                    if (ws == null) {
                        return null;
                    }
                    if (ws instanceof LithQualifier) {
                        return new StringStatus("", ws.getStatus());
                    }
                    return new StringStatus(SB.floatString((double)SB.convFromM((double)((LithInterval)ws).getBaseDepth(), (char)this.units, (char)this.well.getType()), (int)2), ws.getStatus());
                }
                case 2: {
                    return ws == null ? null : new StringStatus(ws.getLithology().toString(), ws.getStatus());
                }
                case 3: {
                    return db != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
                case 4: {
                    return db != null ? SB.floatString((double)SB.convFromM((double)db.getTopDepth(), (char)this.units, (char)this.well.getType()), (int)2) : null;
                }
                case 5: {
                    if (db != null && !(db instanceof LithQualifier)) {
                        return db != null ? SB.floatString((double)SB.convFromM((double)((LithInterval)db).getBaseDepth(), (char)this.units, (char)this.well.getType()), (int)2) : null;
                    }
                    return null;
                }
                case 6: {
                    return db != null ? db.toString() : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return DoubleStatus.class;
            }
            case 4: 
            case 5: {
                return String.class;
            }
            case 2: {
                return StringStatus.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return String.class;
    }
}

