/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbugs.ComboCellRenderer;
import jsbugs.TableModelMatchSamples;
import jsbugs.TableModelSB;
import model2.InterpHdr;
import model2.SBdb;
import util.ArrowCellRenderer;
import util.SB;

class TableModelMatchInterp
extends AbstractTableModel {
    SBdb ws;
    SBdb db;
    int rowCount = 0;
    static String[] colTitle = new String[]{"Name", "", "Name"};
    static final int COL_DONOR = 0;
    static final int COL_ARROW = 1;
    static final int COL_HOST = 2;
    static int[] colWidths = new int[]{100, 16, 100};
    JComboBox interpComboBox = new JComboBox();
    static String NULL_DEFAULT = "<Select>";

    TableModelMatchInterp() {
    }

    @Override
    public int getColumnCount() {
        return colTitle.length;
    }

    @Override
    public int getRowCount() {
        if (this.ws == null) {
            return 0;
        }
        try {
            return this.ws.getInterps().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.ws == null) {
            return null;
        }
        try {
            InterpHdr hdr = (InterpHdr)this.ws.getInterps().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return hdr.getDescription();
                }
                case 2: {
                    return hdr.getLink() == null ? NULL_DEFAULT : hdr.getLink().getDescription();
                }
                case 1: {
                    return hdr.getLink() != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            switch (col) {
                default: {
                    break;
                }
                case 2: {
                    InterpHdr hdr = (InterpHdr)this.ws.getInterps().get(row);
                    InterpHdr dbHdr = this.db.getInterp((String)obj);
                    if (dbHdr != null) {
                        hdr.setLink(dbHdr);
                        break;
                    }
                    hdr.setLink(null);
                    break;
                }
            }
        }
        catch (Exception pe) {
            pe.printStackTrace();
        }
    }

    void setupTable(JTable table, SBdb ws, SBdb db) throws SQLException {
        this.ws = ws;
        this.db = db;
        this.interpComboBox.removeAllItems();
        Iterator it = db.getInterps().iterator();
        while (it.hasNext()) {
            this.interpComboBox.addItem(((InterpHdr)it.next()).getDescription());
        }
        this.interpComboBox.insertItemAt(NULL_DEFAULT, 0);
        for (int i = 0; i < colTitle.length; ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(colTitle[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        table.getColumnModel().getColumn(1).setMaxWidth(TableModelMatchSamples.colWidths[1]);
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.interpComboBox));
        table.getColumnModel().getColumn(2).setCellRenderer(new ComboCellRenderer());
        SB.setTableHeaderBold((JTable)table);
    }
}

