/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import model2.Markers;
import model2.SeismicMarker;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.StringStatus;

class TableModelMatchMarkers
extends AbstractTableModel {
    static final int COL_WS_DEPTH = 0;
    static final int COL_WS_NAME = 1;
    static final int COL_WS_COLOUR = 2;
    static final int COL_ARROW = 3;
    static final int COL_DB_DEPTH = 4;
    static final int COL_DB_NAME = 5;
    static final int COL_DB_COLOUR = 6;
    static final String[] colTitles = new String[]{"Depth", "Name", "Colour", "", "Depth", "Name", "Colour"};
    static final int[] colWidths = new int[]{30, 40, 20, 16, 30, 40, 20};
    char units;
    MatchData data = new MatchData();

    TableModelMatchMarkers() {
    }

    void init(Markers ws, Markers db) throws SBException, SQLException {
        this.data.init(ws.getList(), db != null ? db.getList() : null);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        SeismicMarker ws = (SeismicMarker)pair.getWs();
        SeismicMarker db = (SeismicMarker)pair.getDb();
        switch (columnIndex) {
            case 0: {
                return ws != null ? new StringStatus(SB.getDepthString((double)ws.getDepth(), (char)this.units, (int)2), ws.getStatus()) : null;
            }
            case 1: {
                return ws != null ? ws : null;
            }
            case 2: {
                return ws != null ? ws.getColour() : null;
            }
            case 3: {
                return new Boolean(ws != null && db != null && ws.getStatus() == SbugsStatus.STORED);
            }
            case 4: {
                return db != null ? SB.getDepthString((double)db.getDepth(), (char)this.units, (int)2) : "";
            }
            case 5: {
                return db != null ? db : null;
            }
            case 6: {
                return db != null ? db.getColour() : null;
            }
        }
        return "";
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return StringStatus.class;
            }
            case 4: 
            case 5: {
                return String.class;
            }
            default: {
                return SeismicMarker.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 2: 
            case 6: 
        }
        return Color.class;
    }
}

