/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbugs.ComboCellRenderer;
import jsbugs.SampleTypePair;
import jsbugs.TableModelMatchSamples;
import jsbugs.TableModelSB;
import model2.Sample;
import util.ArrowCellRenderer;
import util.SB;

class TableModelMatchSampleTypes
extends AbstractTableModel {
    private static String[] colTitle = new String[]{"Type", "", "Type"};
    private static final int COL_DONOR = 0;
    private static final int COL_ARROW = 1;
    private static final int COL_HOST = 2;
    private static int[] colWidths = new int[]{50, 16, 50};
    JComboBox sampleComboBox = new JComboBox();
    List<SampleTypePair> types = new LinkedList<SampleTypePair>();

    TableModelMatchSampleTypes() {
    }

    @Override
    public int getColumnCount() {
        return colTitle.length;
    }

    @Override
    public int getRowCount() {
        if (this.types == null) {
            return 0;
        }
        return this.types.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.types == null) {
            return null;
        }
        try {
            SampleTypePair pair = this.types.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return pair.wsType;
                }
                case 2: {
                    return pair.dbType;
                }
                case 1: {
                    return pair.dbType != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 2: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        SampleTypePair pair = this.types.get(row);
        try {
            switch (col) {
                default: {
                    break;
                }
                case 2: {
                    pair.dbType = (String)obj;
                    break;
                }
            }
        }
        catch (Exception pe) {
            pe.printStackTrace();
        }
    }

    void setupTable(JTable table, HashSet<String> wsTypes) throws SQLException {
        this.sampleComboBox.removeAllItems();
        for (int i = 0; i < Sample.getSampleTypes().length; ++i) {
            this.sampleComboBox.addItem(Sample.getSampleTypes()[i]);
        }
        Iterator<String> it = wsTypes.iterator();
        while (it.hasNext()) {
            this.types.add(new SampleTypePair(it.next()));
        }
        for (int i = 0; i < colTitle.length; ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(colTitle[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        table.getColumnModel().getColumn(1).setMaxWidth(TableModelMatchSamples.colWidths[1]);
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.sampleComboBox));
        table.getColumnModel().getColumn(2).setCellRenderer(new ComboCellRenderer());
        SB.setTableHeaderBold((JTable)table);
        table.setToolTipText("Click on blank database Abbreviation to select");
    }
}

