/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import model2.TxGroup;
import util.ArrowCellRenderer;
import util.ColorRenderer;
import util.MatchData;
import util.SB;
import util.SbugsStatusRenderer;
import util.StringStatus;

class TableModelMatchSet
extends AbstractTableModel {
    static final int COL_DONOR_GROUP = 0;
    static final int COL_DONOR_TAXA = 1;
    static final int COL_ARROW = 2;
    static final int COL_HOST_GROUP = 3;
    static final int COL_HOST_TAXA = 4;
    static final String[] colTitles = new String[]{"Group", "No. Taxa", "", "Group", "No. Taxa"};
    static final int[] colWidths = new int[]{120, 20, 16, 120, 20};
    static Boolean linked = true;
    static Boolean unlinked = false;
    MatchData data;

    TableModelMatchSet() {
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        TxGroup ws = (TxGroup)pair.getWs();
        TxGroup db = (TxGroup)pair.getDb();
        try {
            switch (columnIndex) {
                case 0: {
                    return ws == null ? null : new StringStatus(ws.getName(), ws.getStatus());
                }
                case 1: {
                    return ws == null ? null : new StringStatus("" + ws.getSize(), ws.getStatus());
                }
                case 2: {
                    return db != null ? linked : unlinked;
                }
                case 3: {
                    return db;
                }
                case 4: {
                    return db != null ? "" + db.getSize() : "";
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return StringStatus.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return TxGroup.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: 
        }
        return false;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(2).setMaxWidth(colWidths[2]);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
    }
}

