/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.table.AbstractTableModel;
import model2.SQPick;
import model2.Sample;
import util.MatchData;
import util.SB;
import util.StringStatus;

class TableModelMatchSqpick
extends AbstractTableModel {
    static final int COL_WS_SCHEME = 0;
    static final int COL_WS_SAMPLE = 1;
    static final int COL_WS_SURFACE = 2;
    static final int COL_WS_TYPE = 3;
    static final int COL_WS_INFNAME = 4;
    static final int COL_WS_AGE = 5;
    static final int COL_WS_BND = 6;
    static final int COL_WS_QUAL = 7;
    static final int COL_ARROW = 8;
    static final int COL_DB_SCHEME = 9;
    static final int COL_DB_SAMPLE = 10;
    static final int COL_DB_SURFACE = 11;
    static final int COL_DB_TYPE = 12;
    static final int COL_DB_INFNAME = 13;
    static final int COL_DB_AGE = 14;
    static final int COL_DB_BND = 15;
    static final int COL_DB_QUAL = 16;
    static final String[] colTitles = new String[]{"Scheme", "Depth", "Surface", "Type", "Informal name", "Age", "Boundary", "Qualifier", "", "Scheme", "Depth", "Surface", "Type", "Informal name", "Age", "Boundary", "Qualifier"};
    static final int[] colWidths = new int[]{30, 60, 60, 20, 25, 20, 30, 20, 16, 30, 60, 60, 20, 25, 20, 30, 20};
    char units = (char)77;
    MatchData data = new MatchData();

    TableModelMatchSqpick() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        SQPick ws = (SQPick)pair.getWs();
        SQPick db = (SQPick)pair.getDb();
        if (ws != null) {
            ws.getSample().displayUnits = this.units;
        }
        if (db != null) {
            db.getSample().displayUnits = this.units;
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return ws == null ? null : new StringStatus(ws.getSchemeName(true), ws.getStatus());
                }
                case 1: {
                    return ws == null ? null : ws.getSample();
                }
                case 2: {
                    return ws == null ? null : new StringStatus(ws.getSurface().toString(), ws.getStatus());
                }
                case 3: {
                    return ws == null ? null : new StringStatus(ws.getSurface().getTypeString(), ws.getStatus());
                }
                case 4: {
                    return ws == null ? null : new StringStatus(ws.getInfName(), ws.getStatus());
                }
                case 5: {
                    return ws == null ? null : new StringStatus(SB.floatString((double)ws.getSurface().getAge(), (int)2), ws.getStatus());
                }
                case 6: {
                    return ws == null ? null : new StringStatus(ws.getBnd(), ws.getStatus());
                }
                case 7: {
                    return ws == null ? null : new StringStatus(ws.getQualifier(), ws.getStatus());
                }
                case 8: {
                    return new Boolean(ws != null && db != null && ws.getStatus() == Sample.STORED);
                }
                case 9: {
                    return db != null ? db.getSurface().getScheme().toString() : null;
                }
                case 10: {
                    return db != null ? db.getSample().toString() : null;
                }
                case 11: {
                    return db != null ? db.getSurface().toString() : null;
                }
                case 12: {
                    return db != null ? db.getSurface().getTypeString() : null;
                }
                case 13: {
                    return db != null ? db.getInfName() : null;
                }
                case 14: {
                    return db != null ? SB.floatString((double)db.getSurface().getAge(), (int)2) : null;
                }
                case 15: {
                    return db != null ? db.getBnd() : null;
                }
                case 16: {
                    return db != null ? db.getQualifier() : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return StringStatus.class;
            }
            case 8: {
                return Boolean.class;
            }
        }
        return String.class;
    }
}

