/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Toolkit;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.TaxonNameRenderer;
import model2.Project;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import util.ArrowCellRenderer;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;

class TableModelMatchTaxa
extends AbstractTableModel {
    boolean wellData;
    List<Taxon>[] taxa;
    List<Integer>[] nOcc;
    List<Integer>[] nOccImageSets;
    char discID = '\u0000';
    static final int COL_DONCAT = 0;
    static final int COL_DONOR = 1;
    static final int COL_OCCS = 2;
    static final int COL_OCC_IMAGES = 3;
    static final int COL_ARROW = 4;
    static final int COL_HOSTCAT = 5;
    static final int COL_HOST = 6;
    static final int COL_ALPHA = 7;
    static final int COL_OCC_TYPE = 8;
    static final int COL_IMAGES = 9;
    static final String[] colTitles = new String[]{"Cat.", "Donor taxon", "Occurrences", "Image?", "", "Cat.", "Host taxon", "Alpha.Code", "Type", "Image?"};
    static final int[] colWidths = new int[]{20, 130, 10, 10, 16, 20, 130, 30, 30, 10};
    static final int MAXLIST = 5;
    ImageIcon camera = new ImageIcon(Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/CameraSmall.png")));

    TableModelMatchTaxa() {
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    int getListIndex(char discID) {
        if (discID == 'E') {
            return 4;
        }
        return SBdb.did2i((char)discID);
    }

    public void init(SBdb ws, boolean wellData) throws SQLException, SBException {
        this.wellData = wellData;
        if (wellData) {
            this.taxa = new List[5];
            this.nOcc = new List[5];
            this.nOccImageSets = new List[5];
            for (int i = 0; i < 5; ++i) {
                this.taxa[i] = new LinkedList<Taxon>();
                this.nOcc[i] = new LinkedList<Integer>();
                this.nOccImageSets[i] = new LinkedList<Integer>();
            }
            Project project = ws.getProject(0);
            Iterator it = project.getWellIterator();
            while (it.hasNext()) {
                Well well = (Well)it.next();
                Iterator sit = well.getSamples().iterator();
                while (sit.hasNext()) {
                    for (Smpdtl dtl : ((Sample)sit.next()).getAnalyses()) {
                        int disint = SBdb.did2i((char)dtl.getDiscID());
                        List<Taxon> list = this.taxa[disint];
                        List<Integer> nOccList = this.nOcc[disint];
                        List<Integer> nOccImagesList = this.nOccImageSets[disint];
                        for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                            if (occ.getTaxon() == null) {
                                throw new SBException("Occurrence has null taxon reference: " + dtl.getSample() + "," + dtl + "," + occ);
                            }
                            if (!list.contains(occ.getTaxon())) {
                                list.add(occ.getTaxon());
                                nOccList.add(1);
                                nOccImagesList.add(occ.hasImageSet() ? 1 : 0);
                                continue;
                            }
                            int index = list.indexOf(occ.getTaxon());
                            nOccList.set(index, new Integer(nOccList.get(index) + 1));
                            if (!occ.hasImageSet()) continue;
                            nOccImagesList.set(index, new Integer(nOccImagesList.get(index) + 1));
                        }
                    }
                }
            }
            List<Taxon> list = this.taxa[4];
            List<Integer> nOccList = this.nOcc[4];
            for (SBEvent event : ws.getSBEvents(false)) {
                Taxon taxon = event.getTaxon();
                if (taxon == null) continue;
                if (!list.contains(taxon)) {
                    list.add(taxon);
                    nOccList.add(1);
                    continue;
                }
                int index = list.indexOf(taxon);
                nOccList.set(index, new Integer(nOccList.get(index) + 1));
            }
        } else {
            LinkedList<Taxon> taxonList = new LinkedList<Taxon>();
            for (Taxon t : ws.getTaxa()) {
                taxonList.add(t);
            }
            this.taxa = new List[]{taxonList};
            this.nOcc = new List[]{new LinkedList()};
        }
    }

    @Override
    public int getRowCount() {
        if (this.discID == '\u0000') {
            return 0;
        }
        return this.taxa != null ? this.taxa[this.getListIndex(this.discID)].size() : 0;
    }

    public int getNMatched() {
        if (this.discID == '\u0000') {
            return 0;
        }
        int nMatched = 0;
        List<Taxon> hostTaxa = this.taxa[this.getListIndex(this.discID)];
        for (int i = 0; i < hostTaxa.size(); ++i) {
            Taxon taxon = hostTaxa.get(i);
            if (taxon == null || taxon.getLink() == null) continue;
            ++nMatched;
        }
        return nMatched;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.discID == '\u0000') {
            return null;
        }
        List<Taxon> donorTaxa = this.taxa[this.getListIndex(this.discID)];
        if (row >= donorTaxa.size()) {
            return null;
        }
        Taxon donorTaxon = donorTaxa.get(row);
        if (donorTaxon == null && col != 4) {
            return "";
        }
        switch (col) {
            case 0: {
                return donorTaxon.getCatMnem();
            }
            case 1: {
                return donorTaxon;
            }
            case 6: {
                if (donorTaxon.getLink() != null) {
                    return donorTaxon.getLink();
                }
                return "";
            }
            case 4: {
                return donorTaxon != null && donorTaxon.getLink() != null ? TableModelSB.linked : TableModelSB.unlinked;
            }
            case 7: {
                if (donorTaxon.getLink() != null) {
                    return donorTaxon.getLink().getAlphaCode();
                }
                return "";
            }
            case 5: {
                if (donorTaxon.getLink() != null) {
                    return donorTaxon.getLink().getCatMnem();
                }
                return "";
            }
            case 2: {
                if (!this.wellData) {
                    return 0;
                }
                return this.nOcc[this.getListIndex(this.discID)].get(row);
            }
            case 3: {
                if (!this.wellData) {
                    return null;
                }
                if (this.nOccImageSets[this.getListIndex(this.discID)].size() > row) {
                    return this.nOccImageSets[this.getListIndex(this.discID)].get(row) > 0 ? this.camera : null;
                }
                return null;
            }
            case 8: {
                return donorTaxon.getDonorOccType();
            }
            case 9: {
                if (donorTaxon.getLink() == null) break;
                try {
                    return donorTaxon.getLink().hasTypeImage() ? this.camera : null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.discID == '\u0000') {
            return;
        }
        List<Taxon> donorTaxa = this.taxa[this.getListIndex(this.discID)];
        Taxon donor = donorTaxa.get(row);
        switch (col) {
            case 0: 
            case 1: 
            case 8: {
                String occType = (String)obj;
                if (donor.getDonorOccType() != null && donor.getDonorOccType().equals(occType)) break;
                donor.setDonorOccType((String)obj);
                break;
            }
            case 6: {
                donor.setLink((Taxon)obj);
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 8: 
        }
        return true;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 5: 
            case 7: 
            case 8: {
                return String.class;
            }
            case 1: 
            case 6: {
                return Taxon.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: 
            case 9: {
                return ImageIcon.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    List<Taxon> getList() {
        return this.taxa[this.getListIndex(this.discID)];
    }

    void setupTable(JTable jTableMatchTaxa) {
        SB.setTableHeaderBold((JTable)jTableMatchTaxa);
        jTableMatchTaxa.getTableHeader().setReorderingAllowed(false);
        jTableMatchTaxa.setColumnSelectionAllowed(false);
        TableColumnModel columnModel = jTableMatchTaxa.getTableHeader().getColumnModel();
        columnModel.getColumn(4).setMaxWidth(colWidths[4]);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        jTableMatchTaxa.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        jTableMatchTaxa.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        jTableMatchTaxa.setDefaultRenderer(Taxon.class, new TaxonNameRenderer());
        columnModel.getColumn(8).setCellRenderer(new ComboCellRenderer());
    }
}

