/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import jsbugs.FrameJsbugs;
import model2.Sample;
import model2.TaxonOcc;
import util.MatchData;
import util.StringStatus;

class TableModelMatchTaxonOcc
extends AbstractTableModel {
    static final int COL_DONOR_CAT = 0;
    static final int COL_DONOR_OCC = 1;
    static final int COL_DONOR_IMAGE = 2;
    static final int COL_ARROW = 3;
    static final int COL_HOST_CAT = 4;
    static final int COL_HOST_OCC = 5;
    static final int COL_HOST_IMAGE = 6;
    static final String[] colTitles = new String[]{"Cat.", "Taxon", "Image", "", "Cat.", "Taxon", "Image"};
    static final int[] colWidths = new int[]{40, 250, 20, 16, 40, 250, 20};
    char units = (char)77;
    int rowHeight = -1;
    MatchData<TaxonOcc> data = new MatchData();
    ImageIcon camera = new ImageIcon(Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/CameraSmall.png")));
    Boolean linked = true;
    Boolean unlinked = false;

    TableModelMatchTaxonOcc() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        TaxonOcc ws = (TaxonOcc)pair.getWs();
        TaxonOcc db = (TaxonOcc)pair.getDb();
        try {
            switch (columnIndex) {
                case 0: {
                    if (ws == null) {
                        return null;
                    }
                    StringStatus stringStatus = new StringStatus(ws.getTaxon().getCatMnem(), ws.getStatus());
                    return stringStatus;
                }
                case 1: {
                    if (ws == null) {
                        return null;
                    }
                    StringStatus stringStatus = new StringStatus(ws.toStringNoCat(), ws.getStatus());
                    return stringStatus;
                }
                case 2: {
                    if (ws != null) {
                        try {
                            if (!ws.hasImageSet()) return null;
                            return this.camera;
                        }
                        catch (Exception e) {
                            return e.getMessage();
                        }
                    }
                }
                case 3: {
                    Boolean bl;
                    if (ws != null && db != null && ws.getStatus() == Sample.STORED) {
                        bl = this.linked;
                        return bl;
                    }
                    bl = this.unlinked;
                    return bl;
                }
                case 4: {
                    if (db == null) return "";
                    String string = db.getTaxon().getCatMnem();
                    return string;
                }
                case 5: {
                    if (db == null) return "";
                    String string = db.toStringNoCat();
                    return string;
                }
                case 6: {
                    if (db == null) return "";
                    try {
                        if (db.getImage() == null) return null;
                        return this.camera;
                    }
                    catch (Exception e) {
                        return e.getMessage();
                    }
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 3: {
                return Boolean.class;
            }
            case 0: 
            case 1: {
                return StringStatus.class;
            }
            default: {
                return String.class;
            }
            case 2: 
            case 6: 
        }
        return ImageIcon.class;
    }

    boolean hasImages() {
        for (int i = 0; i < this.data.size(); ++i) {
            MatchData.MatchPair pair = this.data.get(i);
            TaxonOcc ws = (TaxonOcc)pair.getWs();
            TaxonOcc db = (TaxonOcc)pair.getDb();
            try {
                if (ws != null && ws.getImage() != null) {
                    return true;
                }
                if (db == null || db.getImage() == null) continue;
                return true;
            }
            catch (Exception e) {
                System.out.println("Exception from image getting in DialogMatchTaxonOcc: " + e.getMessage());
            }
        }
        return false;
    }
}

