/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.table.AbstractTableModel;
import model2.SBdb;
import model2.WellHeader;
import util.MergeStatus;
import util.SB;
import util.SBException;
import util.StringStatus;

class TableModelMatchWellHeader
extends AbstractTableModel {
    static final int COL_PROPERTY = 0;
    static final int COL_DONOR = 1;
    static final int COL_HOST = 2;
    static final String[] colTitles = new String[]{"Well Property", "Workspace", "Database"};
    static final int[] colWidths = new int[]{40, 50, 50};
    static final int ROW_NAME = 0;
    static final int ROW_CODE = 1;
    static final int ROW_OPER = 2;
    static final int ROW_OCS = 3;
    static final int ROW_TYPE = 4;
    static final int ROW_SPUD = 5;
    static final int ROW_COMP = 6;
    static final int ROW_USRID = 7;
    static final int ROW_USERDATE = 8;
    static final int ROW_COUNTRY = 9;
    static final int ROW_COUNTY = 10;
    static final int ROW_FIELD = 11;
    static final int ROW_DATUM = 12;
    static final int ROW_LAT_DEG = 13;
    static final int ROW_LAT_MIN = 14;
    static final int ROW_LAT_SEC = 15;
    static final int ROW_LAT_IND = 16;
    static final int ROW_LONG_DEG = 17;
    static final int ROW_LONG_MIN = 18;
    static final int ROW_LONG_SEC = 19;
    static final int ROW_LONG_IND = 20;
    static final int ROW_LAT_DEC = 21;
    static final int ROW_LONG_DEC = 22;
    static final int ROW_GRIDX = 23;
    static final int ROW_GRIDY = 24;
    static final int ROW_UNITS = 25;
    static final int ROW_RTE = 26;
    static final int ROW_SL = 27;
    static final int ROW_SB = 28;
    static final int ROW_KICKO = 29;
    static final int ROW_TD = 30;
    static final String[] rowTitles = new String[]{"Name :", "Code :", "Operator :", "OCS Number :", "Type :", "Spud :", "Completed :", "Entered by :", "Entered on :", "Country :", "County :", "Field :", "Geodetic Datum :", "Latitude: deg :", "Latitude: min :", "Latitude: sec :", "Latitude: direction :", "Longitude: deg :", "Longitude: min :", "Longitude: sec :", "Longitude: direction :", "Latitude: decimal :", "Longitude: decimal :", "Grid X :", "Grid Y :", "Depth units :", "Rotary Table Elevation :", "Rig Elevation :", "Sea Bed :", "Kick-off depth :", "Terminal Depth :"};
    WellHeader ws;
    WellHeader db;
    SBdb sbdb;

    TableModelMatchWellHeader() {
    }

    @Override
    public int getRowCount() {
        return rowTitles.length;
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    void replace(int[] selection) throws SBException {
        if (this.db == null || this.ws == null) {
            return;
        }
        try {
            for (int row : selection) {
                switch (row) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.db.setOper(this.sbdb, this.ws.getOper());
                        break;
                    }
                    case 3: {
                        this.db.setOCS(this.sbdb, this.ws.getOCS());
                        break;
                    }
                    case 4: {
                        this.db.setType(this.sbdb, this.ws.getType());
                        break;
                    }
                    case 5: {
                        this.db.setSpud(this.sbdb, this.ws.getSpud());
                        break;
                    }
                    case 6: {
                        this.db.setComp(this.sbdb, this.ws.getComp());
                        break;
                    }
                    case 9: {
                        this.db.setCountry(this.sbdb, this.ws.getCountry());
                        break;
                    }
                    case 10: {
                        this.db.setCounty(this.sbdb, this.ws.getCounty());
                        break;
                    }
                    case 11: {
                        this.db.setField(this.sbdb, this.ws.getField());
                    }
                    case 12: {
                        this.db.setGeoDatum(this.sbdb, this.ws.getGeoDatum());
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        break;
                    }
                    case 21: {
                        this.db.setLat(this.sbdb, this.ws.getLat_dec().doubleValue());
                        break;
                    }
                    case 22: {
                        this.db.setLong(this.sbdb, this.ws.getLong_dec().doubleValue());
                        break;
                    }
                    case 23: {
                        this.db.setGridX(this.sbdb, this.ws.getGridX());
                        break;
                    }
                    case 24: {
                        this.db.setGridY(this.sbdb, this.ws.getGridY());
                        break;
                    }
                    case 25: {
                        this.db.setWellUnits(this.sbdb, this.ws.getWellUnits());
                        break;
                    }
                    case 30: {
                        this.db.setTD(this.sbdb, this.ws.getTD());
                        break;
                    }
                    case 27: {
                        this.db.setSL(this.sbdb, this.ws.getSL());
                        break;
                    }
                    case 28: {
                        this.db.setSB(this.sbdb, this.ws.getSB());
                        break;
                    }
                    case 26: {
                        this.db.setRTE(this.sbdb, this.ws.getRTE());
                        break;
                    }
                    case 29: {
                        this.db.setKicko(this.sbdb, this.ws.getKicko());
                    }
                }
                this.sbdb.commit();
            }
            this.db.notifyObservers();
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
            this.sbdb.doRollback();
        }
    }

    void exclude(int[] selection) throws SBException {
        block23: for (int row : selection) {
            switch (row) {
                case 0: 
                case 1: {
                    continue block23;
                }
                case 2: {
                    this.ws.setOper("");
                    continue block23;
                }
                case 3: {
                    this.ws.setOCS("");
                    continue block23;
                }
                case 4: {
                    if (this.db != null) {
                        this.ws.setType(this.db.getType());
                        continue block23;
                    }
                    this.ws.setType('W');
                    continue block23;
                }
                case 5: {
                    this.ws.setSpud(null);
                    continue block23;
                }
                case 6: {
                    this.ws.setComp(null);
                    continue block23;
                }
                case 9: {
                    this.ws.setCountry("");
                    continue block23;
                }
                case 10: {
                    this.ws.setCounty("");
                    continue block23;
                }
                case 11: {
                    this.ws.setField("");
                    continue block23;
                }
                case 12: {
                    this.ws.setGeoDatum("");
                    continue block23;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    continue block23;
                }
                case 21: {
                    this.ws.setLat(null);
                    continue block23;
                }
                case 22: {
                    this.ws.setLong(null);
                    continue block23;
                }
                case 23: {
                    this.ws.setGrid(0.0, this.ws.getGridY());
                    continue block23;
                }
                case 24: {
                    this.ws.setGrid(this.ws.getGridX(), 0.0);
                    continue block23;
                }
                case 25: {
                    this.ws.setWellUnits(this.db != null ? this.db.getWellUnits() : (char)'M');
                    continue block23;
                }
                case 30: {
                    this.ws.setTD(0.0);
                    continue block23;
                }
                case 27: {
                    this.ws.setSL(0.0);
                    continue block23;
                }
                case 28: {
                    this.ws.setSB(0.0);
                    continue block23;
                }
                case 26: {
                    this.ws.setRTE(0.0);
                    continue block23;
                }
                case 29: {
                    this.ws.setKicko(0.0);
                }
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            switch (columnIndex) {
                case 0: {
                    boolean isOutcrop = false;
                    if (this.ws != null && this.ws.getType() == 'O') {
                        isOutcrop = true;
                    }
                    if (this.db != null && this.db.getType() == 'O') {
                        isOutcrop = true;
                    }
                    switch (rowIndex) {
                        default: {
                            return rowTitles[rowIndex];
                        }
                        case 29: {
                            if (isOutcrop) {
                                return "Top of Section";
                            }
                        }
                        case 27: {
                            if (isOutcrop) {
                                return "Outcrop Datum";
                            }
                        }
                        case 26: {
                            if (!isOutcrop) break;
                            return "(RTE)";
                        }
                        case 28: 
                    }
                    if (isOutcrop) {
                        return "(SB)";
                    }
                    return rowTitles[rowIndex];
                }
                case 1: {
                    if (this.ws == null) {
                        return "";
                    }
                    String donor = this.getWellHeaderField(this.ws, rowIndex);
                    String host = "";
                    if (this.db != null) {
                        host = this.getWellHeaderField(this.db, rowIndex);
                    }
                    MergeStatus status = new MergeStatus(WellHeader.STORED);
                    switch (rowIndex) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            status.compareStringField(rowTitles[rowIndex], donor, host, true);
                            break;
                        }
                        case 23: 
                        case 24: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            status.compareDoubleField(rowTitles[rowIndex], Double.parseDouble(donor), host.length() > 0 ? Double.parseDouble(host) : 0.0);
                        }
                    }
                    return new StringStatus(donor, status.getStatus());
                }
                case 2: {
                    if (this.db != null) {
                        return this.getWellHeaderField(this.db, rowIndex);
                    }
                    return "";
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 1: {
                return StringStatus.class;
            }
        }
        return String.class;
    }

    private String getWellHeaderField(WellHeader wh, int propertyIndex) {
        switch (propertyIndex) {
            case 0: {
                return wh.getWellName();
            }
            case 1: {
                return wh.getWellCode();
            }
            case 2: {
                return wh.getOper();
            }
            case 3: {
                return wh.getOCS();
            }
            case 4: {
                return wh.getType() == 'W' ? "Well" : "Outcrop";
            }
            case 5: {
                if (wh.getSpud() != null) {
                    return SB.df.format(wh.getSpud());
                }
                return "";
            }
            case 6: {
                if (wh.getComp() != null) {
                    return SB.df.format(wh.getComp());
                }
                return "";
            }
            case 9: {
                return wh.getCountry();
            }
            case 10: {
                return wh.getCounty();
            }
            case 11: {
                return wh.getField();
            }
            case 12: {
                return wh.getGeoDatum();
            }
            case 13: {
                return "" + (wh.getLat_dec() != null ? Short.valueOf(wh.getLat_deg()) : "");
            }
            case 14: {
                return "" + (wh.getLat_dec() != null ? Integer.valueOf(wh.getLat_min()) : "");
            }
            case 15: {
                return "" + (wh.getLat_dec() != null ? SB.floatString((float)wh.getLat_sec(), (int)1).trim() : "");
            }
            case 16: {
                return "" + (wh.getLat_dec() != null ? Integer.valueOf(wh.getLat_ind()) : "");
            }
            case 17: {
                return "" + (wh.getLong_dec() != null ? Integer.valueOf(wh.getLong_deg()) : "");
            }
            case 18: {
                return "" + (wh.getLong_dec() != null ? Integer.valueOf(wh.getLong_min()) : "");
            }
            case 19: {
                return "" + (wh.getLong_dec() != null ? SB.floatString((float)wh.getLong_sec(), (int)1).trim() : "");
            }
            case 20: {
                return "" + (wh.getLong_dec() != null ? Integer.valueOf(wh.getLong_ind()) : "");
            }
            case 21: {
                return "" + (wh.getLong_dec() != null ? Double.valueOf(wh.getLat_dec()) : "");
            }
            case 22: {
                return "" + (wh.getLong_dec() != null ? Double.valueOf(wh.getLong_dec()) : "");
            }
            case 23: {
                return "" + wh.getGridX();
            }
            case 24: {
                return "" + wh.getGridY();
            }
            case 25: {
                return SB.unitString((char)wh.getWellUnits());
            }
            case 30: {
                return SB.floatString((double)SB.convFromM((double)wh.getTD(), (char)wh.getWellUnits(), (char)wh.getType()), (int)2).trim();
            }
            case 27: {
                return SB.floatString((double)SB.convFromM((double)wh.getSL(), (char)wh.getWellUnits(), (char)wh.getType()), (int)2).trim();
            }
            case 28: {
                return SB.floatString((double)SB.convFromM((double)wh.getSB(), (char)wh.getWellUnits(), (char)wh.getType()), (int)2).trim();
            }
            case 26: {
                return SB.floatString((double)SB.convFromM((double)wh.getRTE(), (char)wh.getWellUnits(), (char)wh.getType()), (int)2).trim();
            }
            case 29: {
                return SB.floatString((double)SB.convFromM((double)wh.getKicko(), (char)wh.getWellUnits(), (char)wh.getType()), (int)2).trim();
            }
        }
        return "";
    }
}

