/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import model2.Taxon;
import util.SB;

class TableModelNumericCodes
extends AbstractTableModel {
    final int CAT_COL = 0;
    final int TAXON_COL = 1;
    final int CODE_COL = 2;
    List<TaxonCode> codes;

    TableModelNumericCodes() {
    }

    @Override
    public int getRowCount() {
        if (this.codes == null) {
            return 0;
        }
        return this.codes.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TaxonCode code = this.codes.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return code.taxon.getCatMnem();
            }
            case 1: {
                return code.taxon;
            }
            case 2: {
                return code.code;
            }
        }
        return null;
    }

    void init(List<TaxonCode> codes, JTable table) {
        this.codes = codes;
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        columnModel.getColumn(0).setHeaderValue("Category");
        columnModel.getColumn(0).setPreferredWidth(20);
        columnModel.getColumn(1).setHeaderValue("Taxon");
        columnModel.getColumn(1).setPreferredWidth(150);
        columnModel.getColumn(2).setHeaderValue("Code");
        columnModel.getColumn(2).setPreferredWidth(30);
    }

    static class TaxonCode
    implements Comparable {
        final Taxon taxon;
        final int code;

        TaxonCode(Taxon taxon, int code) {
            this.taxon = taxon;
            this.code = code;
        }

        public int compareTo(Object o) {
            if (o instanceof TaxonCode) {
                TaxonCode comp = (TaxonCode)o;
                return this.taxon.toString().compareTo(comp.taxon.toString());
            }
            assert (false);
            return 0;
        }
    }
}

