/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Toolkit;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.CountRenderer;
import jsbugs.FrameJsbugs;
import jsbugs.MarkerRenderer;
import jsbugs.SavedRenderer;
import jsbugs.TableModelSB;
import model2.SBdb;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import util.TableSorter;

public class TableModelOccurence
extends TableModelSB {
    Smpdtl smpdtl = null;
    Well well = null;
    boolean splits = false;
    static final String[] columnTitles = new String[]{"Mkr?", "Cat.", "Image", "Name", "Code", "RW", "?", "Abund.", "Coarse", "Medium", "Fine", "Total", "CV", "Type", "Preserv.", "Colour", "Comments"};
    private static final int[] defaultColumnWidths = new int[]{10, 20, 20, 120, 30, 20, 20, 20, 20, 20, 20, 20, 20, 40, 50, 20, 80};
    static final int COL_MARKER = 0;
    static final int COL_CAT = 1;
    static final int COL_IMAGE = 2;
    static final int COL_NAME = 3;
    static final int COL_ALPHACODE = 4;
    static final int COL_RW = 5;
    static final int COL_QUESTION = 6;
    static final int COL_ABUND = 7;
    static final int COL_COARSE = 8;
    static final int COL_MEDIUM = 9;
    static final int COL_FINE = 10;
    static final int COL_AGG = 11;
    static final int COL_CAVED = 12;
    static final int COL_SPECTYPE = 13;
    static final int COL_PRESERV = 14;
    static final int COL_COLOUR = 15;
    static final int COL_COMMENTS = 16;
    static final int IMAGE_ROW_HEIGHT = 50;
    static final int NORMAL_ROW_HEIGHT = 15;
    private boolean logging = false;
    LinkedList<TaxonOcc.Builder> unsaved = null;
    TableSorter sorter = null;
    ImageIcon camera = new ImageIcon(Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/CameraSmall.png")));
    UndoableEditSupport undoSupport = new UndoableEditSupport();

    @Override
    String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    String[] getColumnTitles(JTable table) {
        String titles = "";
        for (int i = 0; i < columnTitles.length; ++i) {
            titles = titles + table.getColumnModel().getColumn(table.convertColumnIndexToModel(i)).getHeaderValue() + ",";
        }
        return titles.split(",");
    }

    @Override
    final String getPrefString() {
        return "TMOCCURREN";
    }

    @Override
    final String getPrefOrderString() {
        return "TOOCCURREN";
    }

    @Override
    final String getAutoResizeString() {
        return "TAROCCUR";
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    public void addUnsaved(TaxonOcc.Builder occ) {
        if (this.unsaved == null) {
            this.unsaved = new LinkedList();
        }
        this.unsaved.add(occ);
    }

    public void setLogging(boolean logging, JTable table) {
        if (logging != this.logging) {
            this.logging = logging;
            this.setSplits(table, this.splits);
        }
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.smpdtl == null) {
            return 0;
        }
        return this.smpdtl.getOccurUnsorted().size() + (this.unsaved != null ? this.unsaved.size() : 0);
    }

    public void setRowHeight(JTable table, TableSorter sorter) {
        if (this.smpdtl == null) {
            return;
        }
        Iterator it = this.smpdtl.getOccur().iterator();
        int row = 0;
        while (it.hasNext()) {
            try {
                if (((TaxonOcc)it.next()).getImage() != null) {
                    table.setRowHeight(sorter.getRowOf(row), 50);
                } else {
                    table.setRowHeight(sorter.getRowOf(row), 15);
                }
            }
            catch (Exception e) {
                table.setRowHeight(sorter.getRowOf(row), 15);
            }
            ++row;
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object fss;
        if (this.smpdtl == null) {
            return null;
        }
        boolean saved = true;
        if (row < this.smpdtl.getOccurUnsorted().size()) {
            fss = this.smpdtl.getOccur().get(row);
        } else {
            fss = this.unsaved.get(row - this.smpdtl.getOccur().size());
            saved = false;
        }
        if (fss == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return new Boolean(saved ? ((TaxonOcc)fss).isMarker() : ((TaxonOcc.Builder)fss).isMarker());
            }
            case 1: {
                return saved ? ((TaxonOcc)fss).getTaxon().getCatMnem() : ((TaxonOcc.Builder)fss).getTaxon().getCatMnem();
            }
            case 3: {
                String t = (saved ? ((TaxonOcc)fss).getTaxon() : ((TaxonOcc.Builder)fss).getTaxon()).toString(false, Taxon.includeAlphaInString, false);
                if (saved) {
                    return t;
                }
                return "*UNSAVED " + t;
            }
            case 4: {
                return (saved ? ((TaxonOcc)fss).getTaxon() : ((TaxonOcc.Builder)fss).getTaxon()).getAlphaCode();
            }
            case 5: {
                if (saved ? ((TaxonOcc)fss).getReworked() : ((TaxonOcc.Builder)fss).isReworked()) {
                    return "Rw";
                }
                return "";
            }
            case 6: {
                if (saved ? ((TaxonOcc)fss).getIdentType() == '?' : ((TaxonOcc.Builder)fss).isQuestionable()) {
                    return "?";
                }
                return "";
            }
            case 7: {
                if (saved && ((TaxonOcc)fss).isOutsideCount()) {
                    return "+";
                }
                return saved ? ((TaxonOcc)fss).getSubAbund() : ((TaxonOcc.Builder)fss).getSubAbund();
            }
            case 8: {
                return saved ? ((TaxonOcc)fss).getCoarse() : ((TaxonOcc.Builder)fss).getCoarse();
            }
            case 9: {
                return saved ? ((TaxonOcc)fss).getMedium() : ((TaxonOcc.Builder)fss).getMedium();
            }
            case 10: {
                return saved ? ((TaxonOcc)fss).getFine() : ((TaxonOcc.Builder)fss).getFine();
            }
            case 11: {
                try {
                    return saved ? "" + (int)((TaxonOcc)fss).getDerivedCount(this.smpdtl.getDatabase().getAbnScheme(this.smpdtl.getHeader().getAbnSchID(), false), this.smpdtl.getCoarse(), this.smpdtl.getMedium(), this.smpdtl.getFine()) : "";
                }
                catch (SQLException sqle) {
                    return sqle.toString();
                }
            }
            case 12: {
                if (saved ? ((TaxonOcc)fss).getCaved() : ((TaxonOcc.Builder)fss).isCaved()) {
                    return "Cv";
                }
                return "";
            }
            case 13: {
                try {
                    return saved ? ((TaxonOcc)fss).getSpecTypeString() : ((TaxonOcc.Builder)fss).getSpecTypeString();
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 14: {
                return saved ? ((TaxonOcc)fss).getPreservation() : ((TaxonOcc.Builder)fss).getPreservation();
            }
            case 15: {
                return saved ? ((TaxonOcc)fss).getColour() : ((TaxonOcc.Builder)fss).getColour();
            }
            case 16: {
                return saved ? ((TaxonOcc)fss).getComment() : ((TaxonOcc.Builder)fss).getComment();
            }
            case 2: {
                try {
                    if (saved && ((TaxonOcc)fss).getImage() != null) {
                        return this.camera;
                    }
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return "Error col: " + col;
    }

    public Object getOcc(int row) {
        TaxonOcc.Builder fss = null;
        if (this.smpdtl != null) {
            fss = row < this.smpdtl.getOccurUnsorted().size() ? (TaxonOcc.Builder)this.smpdtl.getOccurUnsorted().get(row) : this.unsaved.get(row - this.smpdtl.getOccur().size());
        } else {
            System.out.println("Warning: smpdtl null in TableModelOcc.getOcc");
        }
        return fss;
    }

    public boolean getSaved(int row) {
        return row < this.smpdtl.getOccurUnsorted().size();
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            if (this.smpdtl == null) {
                return;
            }
            if (this.well == null) {
                System.out.println("Warning: well null in TableModelOcc.setValueAt");
                return;
            }
            boolean saved = true;
            TaxonOcc fss = null;
            TaxonOcc.Builder builder = null;
            if (row < this.smpdtl.getOccurUnsorted().size()) {
                fss = (TaxonOcc)this.smpdtl.getOccur().get(row);
            } else {
                builder = this.unsaved.get(row - this.smpdtl.getOccur().size());
                saved = false;
            }
            switch (col) {
                default: {
                    return;
                }
                case 8: {
                    int coarse;
                    int n = coarse = obj != null ? Integer.parseInt(obj.toString()) : 0;
                    if (saved && coarse != fss.getCoarse() || !saved && coarse != 0) {
                        if (saved) {
                            this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), fss, 1, coarse - fss.getCoarse(), true));
                        } else {
                            this.unsaved.remove(builder);
                            builder.coarse(coarse);
                            this.undoSupport.postEdit((UndoableEdit)this.smpdtl.insertOccurrence(builder, this.well.getWellID()));
                        }
                        this.well.getDataModel().commit();
                        this.smpdtl.notifyObservers();
                        this.fireTableDataChanged();
                        this.sorter.sort((Object)this);
                    }
                    break;
                }
                case 9: {
                    int medium;
                    int n = medium = obj != null ? Integer.parseInt(obj.toString()) : 0;
                    if (saved && medium != fss.getMedium() || !saved && medium > 0) {
                        if (saved) {
                            this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), fss, 2, medium - fss.getMedium(), true));
                        } else {
                            this.unsaved.remove(builder);
                            builder.count(medium);
                            this.undoSupport.postEdit((UndoableEdit)this.smpdtl.insertOccurrence(builder, this.well.getWellID()));
                        }
                        this.smpdtl.notifyObservers();
                        this.well.getDataModel().commit();
                        this.fireTableDataChanged();
                        this.sorter.sort((Object)this);
                    }
                    break;
                }
                case 10: {
                    int fine;
                    int n = fine = obj != null ? Integer.parseInt(obj.toString()) : 0;
                    if (saved && fine != fss.getFine() || !saved && fine != 0) {
                        if (saved) {
                            this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), fss, 3, fine - fss.getFine(), true));
                        } else {
                            this.unsaved.remove(builder);
                            builder.fine(fine);
                            this.undoSupport.postEdit((UndoableEdit)this.smpdtl.insertOccurrence(builder, this.well.getWellID()));
                        }
                        this.well.getDataModel().commit();
                        this.smpdtl.notifyObservers();
                        this.fireTableDataChanged();
                        this.sorter.sort((Object)this);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.well.getDataModel().doRollback();
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 8: 
            case 10: {
                return this.splits && this.logging;
            }
            case 9: 
        }
        return this.logging;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            default: {
                return String.class;
            }
            case 8: 
            case 9: 
            case 10: {
                return Integer.class;
            }
            case 2: 
        }
        return ImageIcon.class;
    }

    void setupTable(JTable jTableOccurrences, boolean splits, boolean logging, TableSorter sorter, SBdb sbdb) {
        this.sorter = sorter;
        this.init(jTableOccurrences, sbdb);
        jTableOccurrences.setBackground(Color.WHITE);
        jTableOccurrences.getColumnModel().getColumn(0).setCellRenderer(new MarkerRenderer());
        jTableOccurrences.getColumnModel().getColumn(3).setCellRenderer(new SavedRenderer());
        JTextField f = new JTextField();
        f.setHorizontalAlignment(2);
        f.setBorder(null);
        DefaultCellEditor dce = new DefaultCellEditor(f);
        jTableOccurrences.getColumnModel().getColumn(8).setCellEditor(dce);
        jTableOccurrences.getColumnModel().getColumn(9).setCellEditor(dce);
        jTableOccurrences.getColumnModel().getColumn(10).setCellEditor(dce);
        this.logging = logging;
        this.setSplits(jTableOccurrences, splits);
        this.setColumnOrder(jTableOccurrences);
    }

    void setSplits(JTable jTableOccurrences, boolean splits) {
        this.splits = splits;
        TableColumnModel columns = jTableOccurrences.getColumnModel();
        TableColumn coarseCol = columns.getColumn(jTableOccurrences.convertColumnIndexToView(8));
        TableColumn mediumCol = columns.getColumn(jTableOccurrences.convertColumnIndexToView(9));
        TableColumn fineCol = columns.getColumn(jTableOccurrences.convertColumnIndexToView(10));
        coarseCol.setCellRenderer(new CountRenderer(this.logging && splits));
        mediumCol.setCellRenderer(new CountRenderer(this.logging));
        fineCol.setCellRenderer(new CountRenderer(this.logging && splits));
        mediumCol.setHeaderValue(splits ? columnTitles[9] : "Counts");
    }

    @Override
    void setDefaultColumnWidths() {
        System.arraycopy(this.getDefaultColumnWidths(), 0, this.getColumnWidths(), 0, this.getDefaultColumnWidths().length);
        if (!this.splits) {
            this.getColumnWidths()[8] = 0;
            this.getColumnWidths()[10] = 0;
            this.getColumnWidths()[11] = 0;
        }
    }
}

