/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import model2.InterpHdr;
import model2.SBdb;
import model2.WsWell;
import util.DTMonitor;
import util.DTMonitorRenderer;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SbugsStatusRenderer;

public class TableModelOrganiser
extends AbstractTableModel {
    List<WsWell> wsWells = null;
    char units = (char)68;
    private InterpHdr interpHdr = null;
    SBdb db;
    private List<Integer> dataTypes = null;
    static final int ROW_HEIGHT = 20;

    @Override
    public int getColumnCount() {
        if (this.dataTypes == null) {
            return 1;
        }
        return this.dataTypes.size() + 1;
    }

    @Override
    public int getRowCount() {
        if (this.wsWells == null) {
            return 0;
        }
        return this.wsWells.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.wsWells == null) {
            return "";
        }
        try {
            switch (col) {
                case 0: {
                    return this.wsWells.get(row).getHeader();
                }
            }
            return this.wsWells.get(row).getDataMonitor(this.getColumnType(col), this.units, this.interpHdr != null ? this.interpHdr.getInterpID() : 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    int getColumnType(int column) throws SBException {
        int columnType = 0;
        int nColumn = 0;
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            int dataType = this.dataTypes.get(i);
            if (this.interpHdr == null && !SBdb.isInterpDataType((int)dataType)) {
                if (column != ++nColumn) continue;
                columnType = dataType;
                break;
            }
            if (this.interpHdr == null || !SBdb.isInterpDataType((int)dataType) || column != ++nColumn) continue;
            columnType = dataType;
            break;
        }
        return columnType;
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return SbugsStatus.class;
        }
        return DTMonitor.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    void setupTable(JTable jTableOrg) {
        SB.setTableHeaderBold((JTable)jTableOrg);
        jTableOrg.setDefaultRenderer(DTMonitor.class, (TableCellRenderer)new DTMonitorRenderer());
        jTableOrg.setDefaultRenderer(SbugsStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        jTableOrg.setRowHeight(20);
        jTableOrg.getTableHeader().setReorderingAllowed(false);
    }

    void setInterp(InterpHdr hdr) {
        this.interpHdr = hdr;
    }

    void setDataTypes(JTable jTableOrg, List dataTypes) {
        this.dataTypes = dataTypes;
        jTableOrg.getColumnModel().getColumn(0).setHeaderValue("Well/Outcrop");
        while (jTableOrg.getColumnCount() > 1) {
            TableColumn column = jTableOrg.getColumnModel().getColumn(1);
            jTableOrg.removeColumn(column);
        }
        if (dataTypes == null) {
            return;
        }
        int nColumns = 1;
        for (int i = 0; i < dataTypes.size(); ++i) {
            int dataType = this.dataTypes.get(i);
            try {
                if (dataType < 27) {
                    if ((this.interpHdr != null || SBdb.isInterpDataType((int)dataType)) && (this.interpHdr == null || !SBdb.isInterpDataType((int)dataType))) continue;
                    TableColumn column = new TableColumn(nColumns++);
                    column.setHeaderValue(SBdb.dTypeNames[dataType]);
                    column.setPreferredWidth(90);
                    jTableOrg.addColumn(column);
                    continue;
                }
                System.out.println("Can't add data type in OrganiserTableModel: " + dataTypes);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("Can't add data type in OrganiserTableModel: " + dataTypes);
            }
        }
    }
}

