/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import model2.Lastval;
import model2.SBdb;
import util.SB;

public abstract class TableModelSB
extends AbstractTableModel {
    private int[] columnWidths = new int[this.getDefaultColumnWidths().length];
    private int[] columnOrder = new int[this.getDefaultColumnWidths().length];
    static Boolean linked = true;
    static Boolean unlinked = false;

    abstract String getPrefString();

    abstract String getPrefOrderString();

    abstract String getAutoResizeString();

    abstract int[] getDefaultColumnWidths();

    int[] getColumnWidths() {
        return this.columnWidths;
    }

    abstract String[] getColumnTitles();

    String[] getColumnTitles(JTable table) {
        return this.getColumnTitles();
    }

    void init(JTable table, SBdb sbdb) {
        SB.setTableHeaderBold((JTable)table);
        this.setDefaultColumnWidths();
        int autoResize = -1;
        if (sbdb != null) {
            try {
                this.setColumnValues(this.columnWidths, sbdb, this.getPrefString());
                this.setColumnValues(this.columnOrder, sbdb, this.getPrefOrderString());
                autoResize = Lastval.getInt((SBdb)sbdb, (String)this.getAutoResizeString(), (int)-1);
            }
            catch (SQLException sql) {
                System.out.println("Error getting preferences: " + this.getPrefString());
            }
        }
        this.setupColumns(table);
        if (autoResize >= 0) {
            table.setAutoResizeMode(autoResize);
        }
    }

    void setupColumns(JTable table) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(table.convertColumnIndexToView(i));
            column.setHeaderValue(this.getColumnTitles()[i]);
            int prefWidth = this.columnWidths[i];
            if (prefWidth == 0) {
                column.setMinWidth(0);
                column.setMaxWidth(0);
                continue;
            }
            int maxwidth = Integer.MAX_VALUE;
            int minWidth = 15;
            column.setMaxWidth(maxwidth);
            column.setMinWidth(minWidth);
            column.setPreferredWidth(this.columnWidths[i]);
        }
    }

    public void setColumnOrder(JTable table) {
        HashSet<Integer> h = new HashSet<Integer>();
        for (int order : this.columnOrder) {
            if (h.add(order)) continue;
            System.out.println("Table column mis-match in order - quitting");
            return;
        }
        if (this.columnOrder.length != this.getColumnCount()) {
            System.out.println("Table column order no longer the same size as table, column order unset");
            return;
        }
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn[] columns = new TableColumn[this.columnOrder.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = columnModel.getColumn(this.columnOrder[i]);
        }
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        for (TableColumn column : columns) {
            columnModel.addColumn(column);
        }
    }

    void setDefaultColumnWidths() {
        this.columnWidths = new int[this.getDefaultColumnWidths().length];
        System.arraycopy(this.getDefaultColumnWidths(), 0, this.columnWidths, 0, this.getDefaultColumnWidths().length);
    }

    void putTableColumnWidths(SBdb sbdb, JTable table) throws SQLException {
        String widths = "";
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int columnWidth = table.getColumnModel().getColumn(table.convertColumnIndexToView(i)).getWidth();
            widths = widths + columnWidth + " ";
        }
        Lastval.putString((SBdb)sbdb, (String)this.getPrefString(), (String)widths);
        Lastval.putInt((SBdb)sbdb, (String)this.getAutoResizeString(), (int)table.getAutoResizeMode());
    }

    void putTableColumnOrder(SBdb sbdb, JTable table) throws SQLException {
        String order = "";
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int columnOrder = table.convertColumnIndexToView(i);
            order = order + columnOrder + " ";
        }
        Lastval.putString((SBdb)sbdb, (String)this.getPrefOrderString(), (String)order);
    }

    private void setColumnValues(int[] values, SBdb sbdb, String prefString) throws SQLException {
        String widths = Lastval.getString((SBdb)sbdb, (String)prefString);
        if (widths != null && widths.length() > 0) {
            StringTokenizer tok = new StringTokenizer(widths);
            if (tok.countTokens() != this.getColumnCount()) {
                return;
            }
            int i = 0;
            while (tok.hasMoreTokens()) {
                values[i++] = Integer.parseInt(tok.nextToken());
            }
        }
    }
}

