/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.event.MouseMotionListener;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jsbugs.DateRenderer;
import jsbugs.DepthRenderer;
import jsbugs.FloatRenderer;
import jsbugs.SampleLithologyCellRenderer;
import jsbugs.TableModelSB;
import model2.SBdb;
import model2.Sample;
import model2.SampleLithology;
import model2.Well;
import model2.WellInterp;
import util.ColouredRenderer;
import util.SB;
import util.SBException;
import util.TableSorter;

class TableModelSamples
extends TableModelSB {
    private char units = (char)77;
    private WellInterp wellInterp = null;
    private Well well = null;
    SBdb db;
    private boolean simpleDisplay = false;
    static final int COLTOP = 0;
    static final int COLBASE = 1;
    static final int COLTYPE = 2;
    static final int COLLABEL = 3;
    static final int COLLOCAGE = 4;
    static final int COL_NANALY = 5;
    static final int COL_CORR = 6;
    static final int COLCREATED = 7;
    static final int COLMODIFIED = 8;
    static final int COLAGE = 9;
    static final int COLLITH = 10;
    static final int COLSTRAT = 11;
    static String[] columnHeaders = new String[]{"Top Depth", "Base Depth", "Type", "Label", "LOC age", "No.analy.", "Correction +/-", "Created", "Modified", "Age (Ma)", "Lithology", "Stratigraphy"};
    String[] columnTooltips = new String[]{"Top Depth", "Base Depth", "Sample Type", "Label", "Calculated age from Line Of Correlation", "Number of analyses", "Core Correction +/-", "Created Date", "Modified Date", "Assigned Age (Ma)", "Lithology % (cuttings log)", "Stratigraphy"};
    static final int[] simpleDisplayColumns = new int[]{0, 1, 2, 3, 4};
    private static final int[] defaultColumnWidths = new int[]{90, 90, 30, 90, 70, 20, 90, 100, 100, 70, 90, 100};

    public TableModelSamples(boolean simpleDisplay) {
        this.simpleDisplay = simpleDisplay;
    }

    void setSamples(Well well, Observer obs) throws SQLException, SBException {
        this.well = well;
        for (Sample s : well.getSamples()) {
            s.addObserver(obs);
        }
        well.addObserver(obs);
    }

    List<Sample> getSamples() throws SQLException, SBException {
        return this.well != null ? this.well.getSamples() : null;
    }

    @Override
    public int getColumnCount() {
        return this.simpleDisplay ? simpleDisplayColumns.length : columnHeaders.length;
    }

    @Override
    public int getRowCount() {
        if (this.well == null) {
            return 0;
        }
        try {
            return this.well.getSamples().size();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public void setSize(int i) {
    }

    public void setInterp(Well well, WellInterp interp, SBdb db) throws SQLException, SBException {
        this.wellInterp = interp;
        this.well = well;
        this.db = db;
        for (Sample sample : well.getSamples()) {
            sample.getStratigraphy(this.wellInterp, true);
        }
        this.columnTooltips[11] = interp.getHeader().toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int row, int col) {
        if (this.well == null) {
            return "";
        }
        Sample sample = (Sample)this.well.getSamples().get(row);
        switch (col) {
            default: {
                return "";
            }
            case 0: {
                if (sample.hasTopDepth()) {
                    return SB.floatString((double)sample.getTopDepth(this.units), (int)2);
                }
                return "";
            }
            case 1: {
                if (sample.hasBaseDepth()) {
                    return SB.floatString((double)sample.getBaseDepth(this.units), (int)2);
                }
                return "";
            }
            case 2: {
                return sample.getType();
            }
            case 3: {
                return sample.getLabel();
            }
            case 5: {
                return sample.getAnalyses().size();
            }
            case 6: {
                try {
                    double correctedDepth = this.well.getDepth(sample, true, true);
                    double depth = sample.getDepth();
                    double correction = correctedDepth - depth;
                    if (Math.abs(correction) > (double)0.0029f) {
                        return SB.floatString((double)SB.convFromM((double)correction, (char)this.units), (int)2);
                    }
                    return "";
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            case 7: {
                return sample.getCreated();
            }
            case 8: {
                Object modified = null;
                if (!sample.getModified().equals(sample.getCreated())) {
                    return sample.getModified();
                }
                return modified;
            }
            case 10: {
                SampleLithology sl = sample.getLithology();
                return sample.getLithology();
            }
            case 9: {
                if (this.wellInterp != null && sample.getAge(this.wellInterp.getHeader().getInterpID()) != null) {
                    return sample.getAge(this.wellInterp.getHeader().getInterpID());
                }
                return null;
            }
            case 4: {
                if (this.wellInterp != null && this.wellInterp.getLOC() != null) {
                    double age = this.wellInterp.getLOC().getAge(sample.getDepth(), false);
                    if (age > 0.0) {
                        return SB.floatString((double)age, (int)3);
                    }
                    return "";
                }
                return "";
            }
            case 11: 
        }
        {
            catch (Exception e) {
                return e.getMessage();
            }
            try {
                return sample.getStratigraphy(this.wellInterp, false);
            }
            catch (Exception ex) {}
            return ex.getMessage();
        }
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (this.wellInterp == null) {
            JOptionPane.showMessageDialog(null, "Select version from the Interpretations tab before editing age data", "Samples", 1);
            return;
        }
        if (this.db == null) {
            return;
        }
        try {
            Sample sample = (Sample)this.well.getSamples().get(row);
            switch (col) {
                default: {
                    return;
                }
                case 9: 
            }
            if (o == null || o.toString().length() == 0) {
                sample.setAge(this.wellInterp.getHeader().getInterpID(), null, null, null, null, null, this.well.getWellID());
            } else {
                double age = Double.parseDouble(o.toString());
                sample.updateAge(this.well.getWellID(), age, this.wellInterp);
            }
            sample.notifyObservers();
            this.db.commit();
        }
        catch (Exception e) {
            System.out.println("Error in Setting age value: " + e.getMessage());
            e.printStackTrace();
            this.db.doRollback();
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: 
            case 4: {
                return String.class;
            }
            case 10: {
                return List.class;
            }
            case 7: 
            case 8: {
                return Date.class;
            }
            case 9: {
                return Double.class;
            }
            case 5: 
        }
        return Integer.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        switch (c) {
            default: {
                return false;
            }
            case 9: 
        }
        return true;
    }

    void setupTable(JTable jTableSamples, TableSorter sorter, boolean tips, SBdb sbdb) {
        this.init(jTableSamples, sbdb);
        jTableSamples.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
        jTableSamples.getColumnModel().getColumn(1).setCellRenderer(new DepthRenderer());
        jTableSamples.setDefaultRenderer(List.class, new SampleLithologyCellRenderer());
        jTableSamples.setDefaultRenderer(Double.class, new FloatRenderer());
        jTableSamples.setDefaultRenderer(Integer.class, (TableCellRenderer)new ColouredRenderer(true, new Color(220, 220, 220)));
        jTableSamples.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)new ColouredRenderer(false, new Color(220, 220, 220)));
        if (!this.simpleDisplay) {
            jTableSamples.getColumnModel().getColumn(7).setCellRenderer(new DateRenderer());
            jTableSamples.getColumnModel().getColumn(8).setCellRenderer(new DateRenderer());
            jTableSamples.getColumnModel().getColumn(6).setCellRenderer((TableCellRenderer)new ColouredRenderer(true, new Color(220, 220, 220)));
            jTableSamples.getColumnModel().getColumn(11).setCellRenderer((TableCellRenderer)new ColouredRenderer(true, new Color(220, 220, 220)));
        }
        if (tips) {
            jTableSamples.getTableHeader().addMouseMotionListener((MouseMotionListener)sorter.createColumnHeaderToolTips(this.columnTooltips, jTableSamples));
        }
    }

    void setUnits(char units) {
        this.units = units;
        if (this.well != null) {
            try {
                for (Sample sample : this.well.getSamples()) {
                    sample.displayUnits = units;
                }
            }
            catch (Exception ex) {
                SB.showStackError((String)ex.toString(), (Exception)ex);
            }
        }
    }

    char getUnits() {
        return this.units;
    }

    @Override
    String[] getColumnTitles() {
        return columnHeaders;
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    String getPrefString() {
        return "TMSAMPLES";
    }

    @Override
    String getPrefOrderString() {
        return "TOSAMPLES";
    }

    @Override
    final String getAutoResizeString() {
        return "TARSAMPLES";
    }
}

