/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.LinkedList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jsbugs.UnitSearchResult;
import model2.IGDInterval;
import util.ColorRenderer;
import util.SB;

class TableModelSearchUnit
extends AbstractTableModel {
    LinkedList<UnitSearchResult> entries = null;
    static String[] colTitles = new String[]{"Type", "Scheme", "Unit name", "Upper Age", "Lower Age", "Colour"};
    static int[] colWidths = new int[]{50, 50, 50, 30, 30, 10};
    static final int COL_TYPE = 0;
    static final int COL_SCHEME = 1;
    static final int COL_NAME = 2;
    static final int COL_UAGE = 3;
    static final int COL_LAGE = 4;
    static final int COL_COLOUR = 5;

    TableModelSearchUnit() {
    }

    @Override
    public int getRowCount() {
        if (this.entries == null) {
            return 0;
        }
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.entries == null) {
            return null;
        }
        UnitSearchResult entry = this.entries.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return IGDInterval.getIGDName((int)entry.scheme.getIGDType());
            }
            case 1: {
                return entry.scheme.getName();
            }
            case 2: {
                return entry.unitName;
            }
            case 3: {
                return entry.uAge;
            }
            case 4: {
                return entry.lAge;
            }
            case 5: {
                return entry.colour;
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: 
            case 4: {
                return Double.class;
            }
            case 5: {
                return Color.class;
            }
        }
        return Object.class;
    }

    void setupTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(table.convertColumnIndexToView(i));
            column.setHeaderValue(colTitles[i]);
            column.setPreferredWidth(colWidths[i]);
            if (i != 5) continue;
            column.setCellRenderer((TableCellRenderer)new ColorRenderer(false));
        }
    }
}

