/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.FrameJsbugs;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.Surface;
import util.SB;
import util.SBException;

class TableModelSurfaces
extends AbstractTableModel {
    IGDScheme scheme = null;
    static String[] colTitles = new String[]{"Surface Name", "Type", "Age", "Occs", "Unit"};
    static int[] colWidths = new int[]{90, 20, 20, 20, 30};
    static final int COL_NAME = 0;
    static final int COL_TYPE = 1;
    static final int COL_AGE = 2;
    static final int COL_OCCS = 3;
    static final int COL_UNIT = 4;
    boolean editable = false;

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.scheme == null) {
            return 0;
        }
        try {
            return this.scheme.getSurfaces().size();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error getting surfaces", sql, this.scheme.getDatabase());
            return 0;
        }
    }

    IGDScheme getScheme() {
        return this.scheme;
    }

    void setScheme(IGDScheme scheme) throws SQLException, SBException {
        scheme.loadUnits();
        scheme.getSurfaces();
        this.scheme = scheme;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.scheme == null) {
            return "";
        }
        try {
            Surface surface = (Surface)this.scheme.getSurfaces().get(row);
            switch (col) {
                case 0: {
                    return surface.getName();
                }
                case 1: {
                    return surface.getTypeString();
                }
                case 2: {
                    return new Double(surface.getAge());
                }
                case 3: {
                    return surface.getNoccs(false);
                }
                case 4: {
                    try {
                        IGDUnit unit = this.scheme.findUnit(surface.getAge());
                        if (unit == null) {
                            unit = this.scheme.findUnit(surface.getName());
                        }
                        if (unit == null) {
                            return "";
                        }
                        return unit;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return "Error";
                    }
                }
            }
            return "";
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error getting surfaces", sql, this.scheme.getDatabase());
            return "";
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.scheme == null) {
            return;
        }
        try {
            Surface surface = (Surface)this.scheme.getSurfaces().get(row);
            boolean changed = false;
            switch (col) {
                case 0: {
                    if (surface.getName().equals(obj)) break;
                    surface.setName((String)obj);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    surface.setAge(((Double)obj).doubleValue());
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return String.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return IGDUnit.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.editable) {
            return false;
        }
        switch (col) {
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    void setupTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        table.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < colTitles.length; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            table.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
        }
    }
}

