/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import model2.SBdb;
import model2.TaxonWellImage;
import model2.Well;

class TableModelTaxonImage
extends AbstractTableModel {
    static final int IMAGE_SIZE = 80;
    List<TaxonWellImage> data = null;
    SBdb db;
    static String[] colTitles = new String[]{"Well", "Depth", "Sample Type", "Disc", "Analyst", "Analy.No.", "Caption to 1st image", "No. in Set", "Image", "Type?"};
    static int[] colWidth = new int[]{50, 30, 20, 10, 20, 10, 100, 10, 80, 10};
    static final int COL_WELL = 0;
    static final int COL_DEPTH = 1;
    static final int COL_TYPE = 2;
    static final int COL_DISC = 3;
    static final int COL_ANALYST = 4;
    static final int COL_ANALYNO = 5;
    static final int COL_CAPTION = 6;
    static final int COL_NIMAGES = 7;
    static final int COL_IMAGE = 8;
    static final int COL_TXTYPE = 9;

    TableModelTaxonImage() {
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        TaxonWellImage item = this.data.get(row);
        try {
            switch (col) {
                case 0: {
                    return item.well;
                }
                case 1: {
                    return item.sample != null ? Double.valueOf(item.sample.getDepth(item.well.getWellUnits())) : null;
                }
                case 2: {
                    return item.sample != null ? item.sample.getType() : null;
                }
                case 3: {
                    return item.smpdtl != null ? SBdb.getDiscAbr((char)item.smpdtl.getDiscID()) : null;
                }
                case 4: {
                    return item.smpdtl != null ? item.smpdtl.getAnalyst() : null;
                }
                case 5: {
                    return item.smpdtl != null ? Integer.valueOf(item.smpdtl.getAnalyNo()) : null;
                }
                case 7: {
                    return item.imageSet.getSize();
                }
                case 6: {
                    return item.imageSet.getImage(0).getCaption();
                }
                case 8: {
                    ImageIcon icon = item.imageSet.getImage(0).getImage(80, 80, true);
                    return icon;
                }
                case 9: {
                    return item.isType ? "Y" : "";
                }
            }
            return "";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Well.class;
            }
            case 1: {
                return Float.class;
            }
            default: {
                return String.class;
            }
            case 5: 
            case 7: {
                return Integer.class;
            }
            case 8: 
        }
        return ImageIcon.class;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }
}

