/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.DepthRenderer;
import jsbugs.MarkerRenderer;
import jsbugs.Occurrence;
import model2.SBdb;
import model2.Sample;
import util.SB;
import util.TableSorter;

class TableModelTaxonOccurrence
extends AbstractTableModel {
    LinkedList<Occurrence> occs = null;
    char units = (char)77;
    static String[] columnTitles = new String[]{"Top Depth", "Base Depth", "Type", "Disc.", "Analyst", "Suite", "Name", "Abund.", "Rw", "Cv", "?", "Mkr", "Comments", "Images"};
    static int[] columnWidths = new int[]{25, 25, 10, 20, 20, 10, 100, 20, 10, 10, 10, 10, 100, 50};
    static final int COL_TOP_DEPTH = 0;
    static final int COL_BASE_DEPTH = 1;
    static final int COL_TYPE = 2;
    static final int COL_DISC = 3;
    static final int COL_ANALYST = 4;
    static final int COL_SUITE = 5;
    static final int COL_NAME = 6;
    static final int COL_ABUND = 7;
    static final int COL_RW = 8;
    static final int COL_CV = 9;
    static final int COL_QUEST = 10;
    static final int COL_MKR = 11;
    static final int COL_COMMENTS = 12;
    static final int COL_IMAGE = 13;
    static final int IMAGE_ROW_HEIGHT = 50;
    static final int NORMAL_ROW_HEIGHT = 15;

    TableModelTaxonOccurrence() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.occs == null) {
            return 0;
        }
        return this.occs.size();
    }

    public void setRowHeight(JTable table, TableSorter sorter) {
        if (this.occs == null) {
            return;
        }
        Iterator it = this.occs.iterator();
        int row = 0;
        while (it.hasNext()) {
            try {
                if (((Occurrence)it.next()).occ.getImage() != null) {
                    table.setRowHeight(sorter.getRowOf(row), 50);
                } else {
                    table.setRowHeight(sorter.getRowOf(row), 15);
                }
            }
            catch (Exception e) {
                table.setRowHeight(sorter.getRowOf(row), 15);
            }
            ++row;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int row, int col) {
        if (this.occs == null) {
            return null;
        }
        Occurrence occ = this.occs.get(row);
        Sample sample = occ.smpdtl.getSample();
        try {
            switch (col) {
                case 0: {
                    if (!sample.hasTopDepth()) return "";
                    return SB.floatString((double)sample.getTopDepth(this.units), (int)2);
                }
                case 1: {
                    if (!sample.hasBaseDepth()) return "";
                    return SB.floatString((double)sample.getBaseDepth(this.units), (int)2);
                }
                case 2: {
                    return sample.getType();
                }
                case 3: {
                    return SBdb.getDiscAbr((char)occ.smpdtl.getDiscID());
                }
                case 4: {
                    return occ.smpdtl.getAnalyst();
                }
                case 5: {
                    return "" + occ.smpdtl.getAnalyNo();
                }
                case 6: {
                    return occ.occ.getTaxon().toString(false, false, false);
                }
                case 7: {
                    String abn = occ.occ.getSubAbund(true);
                    if (!abn.isEmpty()) return abn;
                    return abn + occ.occ.getSplitCountString();
                }
                case 8: {
                    if (!occ.occ.getReworked()) return "";
                    return "Rw";
                }
                case 9: {
                    if (!occ.occ.getCaved()) return "";
                    return "Cv";
                }
                case 10: {
                    if (occ.occ.getIdentType() != '?') return "";
                    return "?";
                }
                case 12: {
                    return occ.occ.getComment();
                }
                case 11: {
                    return new Boolean(occ.occ.isMarker());
                }
                case 13: {
                    try {
                        if (occ.occ.getImage() == null) return null;
                        return occ.occ.getImage().getThumb(50);
                    }
                    catch (Exception e) {
                        return e.getMessage();
                    }
                }
            }
            return "Error col: " + col;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 13: 
        }
        return ImageIcon.class;
    }

    void setList(LinkedList<Occurrence> occs) {
        this.occs = occs;
    }

    void setUnits(char units) {
        this.units = units;
    }

    void setupTable(JTable jTableOccs) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTableOccs.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
            jTableOccs.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        jTableOccs.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
        jTableOccs.getColumnModel().getColumn(1).setCellRenderer(new DepthRenderer());
        jTableOccs.getColumnModel().getColumn(11).setCellRenderer(new MarkerRenderer());
        SB.setTableHeaderBold((JTable)jTableOccs);
    }
}

